/*
 * Decompiled with CFR 0.152.
 */
package net.weavemc.relocate.google.common.graph;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import net.weavemc.relocate.google.common.base.Preconditions;
import net.weavemc.relocate.google.common.collect.ImmutableMap;
import net.weavemc.relocate.google.common.graph.GraphConnections;

final class UndirectedGraphConnections<N, V>
implements GraphConnections<N, V> {
    private final Map<N, V> adjacentNodeValues;

    private UndirectedGraphConnections(Map<N, V> adjacentNodeValues) {
        this.adjacentNodeValues = Preconditions.checkNotNull(adjacentNodeValues);
    }

    static <N, V> UndirectedGraphConnections<N, V> of() {
        return new UndirectedGraphConnections(new HashMap(2, 1.0f));
    }

    static <N, V> UndirectedGraphConnections<N, V> ofImmutable(Map<N, V> adjacentNodeValues) {
        return new UndirectedGraphConnections<N, V>(ImmutableMap.copyOf(adjacentNodeValues));
    }

    @Override
    public Set<N> adjacentNodes() {
        return Collections.unmodifiableSet(this.adjacentNodeValues.keySet());
    }

    @Override
    public Set<N> predecessors() {
        return this.adjacentNodes();
    }

    @Override
    public Set<N> successors() {
        return this.adjacentNodes();
    }

    @Override
    public V value(Object node2) {
        return this.adjacentNodeValues.get(node2);
    }

    @Override
    public void removePredecessor(Object node2) {
        V unused = this.removeSuccessor(node2);
    }

    @Override
    public V removeSuccessor(Object node2) {
        return this.adjacentNodeValues.remove(node2);
    }

    @Override
    public void addPredecessor(N node2, V value) {
        V unused = this.addSuccessor(node2, value);
    }

    @Override
    public V addSuccessor(N node2, V value) {
        return this.adjacentNodeValues.put(node2, value);
    }
}

