/*
 * Decompiled with CFR 0.152.
 */
package net.weavemc.relocate.google.common.graph;

import net.weavemc.relocate.google.common.annotations.Beta;
import net.weavemc.relocate.google.common.base.Function;
import net.weavemc.relocate.google.common.base.Functions;
import net.weavemc.relocate.google.common.base.Preconditions;
import net.weavemc.relocate.google.common.collect.ImmutableMap;
import net.weavemc.relocate.google.common.collect.Maps;
import net.weavemc.relocate.google.common.graph.AbstractGraphBuilder;
import net.weavemc.relocate.google.common.graph.ConfigurableValueGraph;
import net.weavemc.relocate.google.common.graph.DirectedGraphConnections;
import net.weavemc.relocate.google.common.graph.ForwardingGraph;
import net.weavemc.relocate.google.common.graph.Graph;
import net.weavemc.relocate.google.common.graph.GraphBuilder;
import net.weavemc.relocate.google.common.graph.GraphConnections;
import net.weavemc.relocate.google.common.graph.GraphConstants;
import net.weavemc.relocate.google.common.graph.UndirectedGraphConnections;
import net.weavemc.relocate.google.common.graph.ValueGraph;

@Beta
public abstract class ImmutableGraph<N>
extends ForwardingGraph<N> {
    ImmutableGraph() {
    }

    public static <N> ImmutableGraph<N> copyOf(Graph<N> graph) {
        return graph instanceof ImmutableGraph ? (ImmutableGraph<N>)graph : new ValueBackedImpl<N, GraphConstants.Presence>(GraphBuilder.from(graph), ImmutableGraph.getNodeConnections(graph), graph.edges().size());
    }

    @Deprecated
    public static <N> ImmutableGraph<N> copyOf(ImmutableGraph<N> graph) {
        return Preconditions.checkNotNull(graph);
    }

    private static <N> ImmutableMap<N, GraphConnections<N, GraphConstants.Presence>> getNodeConnections(Graph<N> graph) {
        ImmutableMap.Builder<N, GraphConnections<N, GraphConstants.Presence>> nodeConnections = ImmutableMap.builder();
        for (N node2 : graph.nodes()) {
            nodeConnections.put(node2, ImmutableGraph.connectionsOf(graph, node2));
        }
        return nodeConnections.build();
    }

    private static <N> GraphConnections<N, GraphConstants.Presence> connectionsOf(Graph<N> graph, N node2) {
        Function<Object, GraphConstants.Presence> edgeValueFn = Functions.constant(GraphConstants.Presence.EDGE_EXISTS);
        return graph.isDirected() ? DirectedGraphConnections.ofImmutable(graph.predecessors(node2), Maps.asMap(graph.successors(node2), edgeValueFn)) : UndirectedGraphConnections.ofImmutable(Maps.asMap(graph.adjacentNodes(node2), edgeValueFn));
    }

    static class ValueBackedImpl<N, V>
    extends ImmutableGraph<N> {
        protected final ValueGraph<N, V> backingValueGraph;

        ValueBackedImpl(AbstractGraphBuilder<? super N> builder, ImmutableMap<N, GraphConnections<N, V>> nodeConnections, long edgeCount) {
            this.backingValueGraph = new ConfigurableValueGraph<N, V>(builder, nodeConnections, edgeCount);
        }

        @Override
        protected Graph<N> delegate() {
            return this.backingValueGraph;
        }
    }
}

