/*
 * Decompiled with CFR 0.152.
 */
package net.weavemc.relocate.google.common.graph;

import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javax.annotation.Nullable;
import net.weavemc.relocate.google.common.base.Preconditions;
import net.weavemc.relocate.google.common.collect.ImmutableSet;
import net.weavemc.relocate.google.common.graph.AbstractNetwork;
import net.weavemc.relocate.google.common.graph.ElementOrder;
import net.weavemc.relocate.google.common.graph.EndpointPair;
import net.weavemc.relocate.google.common.graph.MapIteratorCache;
import net.weavemc.relocate.google.common.graph.MapRetrievalCache;
import net.weavemc.relocate.google.common.graph.NetworkBuilder;
import net.weavemc.relocate.google.common.graph.NetworkConnections;

class ConfigurableNetwork<N, E>
extends AbstractNetwork<N, E> {
    private final boolean isDirected;
    private final boolean allowsParallelEdges;
    private final boolean allowsSelfLoops;
    private final ElementOrder<N> nodeOrder;
    private final ElementOrder<E> edgeOrder;
    protected final MapIteratorCache<N, NetworkConnections<N, E>> nodeConnections;
    protected final MapIteratorCache<E, N> edgeToReferenceNode;

    ConfigurableNetwork(NetworkBuilder<? super N, ? super E> builder) {
        this(builder, builder.nodeOrder.createMap(builder.expectedNodeCount.or(10)), builder.edgeOrder.createMap(builder.expectedEdgeCount.or(20)));
    }

    ConfigurableNetwork(NetworkBuilder<? super N, ? super E> builder, Map<N, NetworkConnections<N, E>> nodeConnections, Map<E, N> edgeToReferenceNode) {
        this.isDirected = builder.directed;
        this.allowsParallelEdges = builder.allowsParallelEdges;
        this.allowsSelfLoops = builder.allowsSelfLoops;
        this.nodeOrder = builder.nodeOrder.cast();
        this.edgeOrder = builder.edgeOrder.cast();
        this.nodeConnections = nodeConnections instanceof TreeMap ? new MapRetrievalCache<N, NetworkConnections<N, E>>(nodeConnections) : new MapIteratorCache<N, NetworkConnections<N, E>>(nodeConnections);
        this.edgeToReferenceNode = new MapIteratorCache<E, N>(edgeToReferenceNode);
    }

    @Override
    public Set<N> nodes() {
        return this.nodeConnections.unmodifiableKeySet();
    }

    @Override
    public Set<E> edges() {
        return this.edgeToReferenceNode.unmodifiableKeySet();
    }

    @Override
    public boolean isDirected() {
        return this.isDirected;
    }

    @Override
    public boolean allowsParallelEdges() {
        return this.allowsParallelEdges;
    }

    @Override
    public boolean allowsSelfLoops() {
        return this.allowsSelfLoops;
    }

    @Override
    public ElementOrder<N> nodeOrder() {
        return this.nodeOrder;
    }

    @Override
    public ElementOrder<E> edgeOrder() {
        return this.edgeOrder;
    }

    @Override
    public Set<E> incidentEdges(Object node2) {
        return this.checkedConnections(node2).incidentEdges();
    }

    @Override
    public EndpointPair<N> incidentNodes(Object edge) {
        N nodeU = this.checkedReferenceNode(edge);
        N nodeV = this.nodeConnections.get(nodeU).oppositeNode(edge);
        return EndpointPair.of(this, nodeU, nodeV);
    }

    @Override
    public Set<N> adjacentNodes(Object node2) {
        return this.checkedConnections(node2).adjacentNodes();
    }

    @Override
    public Set<E> edgesConnecting(Object nodeU, Object nodeV) {
        NetworkConnections<N, E> connectionsU = this.checkedConnections(nodeU);
        if (!this.allowsSelfLoops && nodeU == nodeV) {
            return ImmutableSet.of();
        }
        Preconditions.checkArgument(this.containsNode(nodeV), "Node %s is not an element of this graph.", nodeV);
        return connectionsU.edgesConnecting(nodeV);
    }

    @Override
    public Set<E> inEdges(Object node2) {
        return this.checkedConnections(node2).inEdges();
    }

    @Override
    public Set<E> outEdges(Object node2) {
        return this.checkedConnections(node2).outEdges();
    }

    @Override
    public Set<N> predecessors(Object node2) {
        return this.checkedConnections(node2).predecessors();
    }

    @Override
    public Set<N> successors(Object node2) {
        return this.checkedConnections(node2).successors();
    }

    protected final NetworkConnections<N, E> checkedConnections(Object node2) {
        NetworkConnections<N, E> connections = this.nodeConnections.get(node2);
        if (connections == null) {
            Preconditions.checkNotNull(node2);
            throw new IllegalArgumentException(String.format("Node %s is not an element of this graph.", node2));
        }
        return connections;
    }

    protected final N checkedReferenceNode(Object edge) {
        N referenceNode = this.edgeToReferenceNode.get(edge);
        if (referenceNode == null) {
            Preconditions.checkNotNull(edge);
            throw new IllegalArgumentException(String.format("Edge %s is not an element of this graph.", edge));
        }
        return referenceNode;
    }

    protected final boolean containsNode(@Nullable Object node2) {
        return this.nodeConnections.containsKey(node2);
    }

    protected final boolean containsEdge(@Nullable Object edge) {
        return this.edgeToReferenceNode.containsKey(edge);
    }
}

