/*
 * Decompiled with CFR 0.152.
 */
package net.weavemc.relocate.google.common.graph;

import java.util.AbstractSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import net.weavemc.relocate.google.common.annotations.Beta;
import net.weavemc.relocate.google.common.base.Function;
import net.weavemc.relocate.google.common.collect.ImmutableSet;
import net.weavemc.relocate.google.common.collect.Iterators;
import net.weavemc.relocate.google.common.collect.Maps;
import net.weavemc.relocate.google.common.collect.Sets;
import net.weavemc.relocate.google.common.graph.AbstractGraph;
import net.weavemc.relocate.google.common.graph.ElementOrder;
import net.weavemc.relocate.google.common.graph.EndpointPair;
import net.weavemc.relocate.google.common.graph.Graph;
import net.weavemc.relocate.google.common.graph.Network;
import net.weavemc.relocate.google.common.math.IntMath;

@Beta
public abstract class AbstractNetwork<N, E>
implements Network<N, E> {
    @Override
    public Graph<N> asGraph() {
        return new AbstractGraph<N>(){

            @Override
            public Set<N> nodes() {
                return AbstractNetwork.this.nodes();
            }

            @Override
            public Set<EndpointPair<N>> edges() {
                if (AbstractNetwork.this.allowsParallelEdges()) {
                    return super.edges();
                }
                return new AbstractSet<EndpointPair<N>>(){

                    @Override
                    public Iterator<EndpointPair<N>> iterator() {
                        return Iterators.transform(AbstractNetwork.this.edges().iterator(), new Function<E, EndpointPair<N>>(){

                            @Override
                            public EndpointPair<N> apply(E edge) {
                                return AbstractNetwork.this.incidentNodes(edge);
                            }
                        });
                    }

                    @Override
                    public int size() {
                        return AbstractNetwork.this.edges().size();
                    }

                    @Override
                    public boolean contains(@Nullable Object obj) {
                        if (!(obj instanceof EndpointPair)) {
                            return false;
                        }
                        EndpointPair endpointPair = (EndpointPair)obj;
                        return this.isDirected() == endpointPair.isOrdered() && this.nodes().contains(endpointPair.nodeU()) && this.successors(endpointPair.nodeU()).contains(endpointPair.nodeV());
                    }
                };
            }

            @Override
            public ElementOrder<N> nodeOrder() {
                return AbstractNetwork.this.nodeOrder();
            }

            @Override
            public boolean isDirected() {
                return AbstractNetwork.this.isDirected();
            }

            @Override
            public boolean allowsSelfLoops() {
                return AbstractNetwork.this.allowsSelfLoops();
            }

            @Override
            public Set<N> adjacentNodes(Object node2) {
                return AbstractNetwork.this.adjacentNodes(node2);
            }

            @Override
            public Set<N> predecessors(Object node2) {
                return AbstractNetwork.this.predecessors(node2);
            }

            @Override
            public Set<N> successors(Object node2) {
                return AbstractNetwork.this.successors(node2);
            }
        };
    }

    @Override
    public int degree(Object node2) {
        if (this.isDirected()) {
            return IntMath.saturatedAdd(this.inEdges(node2).size(), this.outEdges(node2).size());
        }
        return IntMath.saturatedAdd(this.incidentEdges(node2).size(), this.edgesConnecting(node2, node2).size());
    }

    @Override
    public int inDegree(Object node2) {
        return this.isDirected() ? this.inEdges(node2).size() : this.degree(node2);
    }

    @Override
    public int outDegree(Object node2) {
        return this.isDirected() ? this.outEdges(node2).size() : this.degree(node2);
    }

    @Override
    public Set<E> adjacentEdges(Object edge) {
        EndpointPair endpointPair = this.incidentNodes(edge);
        Sets.SetView endpointPairIncidentEdges = Sets.union(this.incidentEdges(endpointPair.nodeU()), this.incidentEdges(endpointPair.nodeV()));
        return Sets.difference(endpointPairIncidentEdges, ImmutableSet.of(edge));
    }

    public String toString() {
        String propertiesString = String.format("isDirected: %s, allowsParallelEdges: %s, allowsSelfLoops: %s", this.isDirected(), this.allowsParallelEdges(), this.allowsSelfLoops());
        return String.format("%s, nodes: %s, edges: %s", propertiesString, this.nodes(), this.edgeIncidentNodesMap());
    }

    private Map<E, EndpointPair<N>> edgeIncidentNodesMap() {
        Function edgeToIncidentNodesFn = new Function<E, EndpointPair<N>>(){

            @Override
            public EndpointPair<N> apply(E edge) {
                return AbstractNetwork.this.incidentNodes(edge);
            }
        };
        return Maps.asMap(this.edges(), edgeToIncidentNodesFn);
    }
}

