/*
 * Decompiled with CFR 0.152.
 */
package net.weavemc.relocate.google.common.graph;

import java.util.AbstractSet;
import java.util.Set;
import javax.annotation.Nullable;
import net.weavemc.relocate.google.common.annotations.Beta;
import net.weavemc.relocate.google.common.base.Preconditions;
import net.weavemc.relocate.google.common.collect.UnmodifiableIterator;
import net.weavemc.relocate.google.common.graph.EndpointPair;
import net.weavemc.relocate.google.common.graph.EndpointPairIterator;
import net.weavemc.relocate.google.common.graph.Graph;
import net.weavemc.relocate.google.common.math.IntMath;
import net.weavemc.relocate.google.common.primitives.Ints;

@Beta
public abstract class AbstractGraph<N>
implements Graph<N> {
    protected long edgeCount() {
        long degreeSum = 0L;
        for (Object node2 : this.nodes()) {
            degreeSum += (long)this.degree(node2);
        }
        Preconditions.checkState((degreeSum & 1L) == 0L);
        return degreeSum >>> 1;
    }

    @Override
    public Set<EndpointPair<N>> edges() {
        return new AbstractSet<EndpointPair<N>>(){

            @Override
            public UnmodifiableIterator<EndpointPair<N>> iterator() {
                return EndpointPairIterator.of(AbstractGraph.this);
            }

            @Override
            public int size() {
                return Ints.saturatedCast(AbstractGraph.this.edgeCount());
            }

            @Override
            public boolean contains(@Nullable Object obj) {
                if (!(obj instanceof EndpointPair)) {
                    return false;
                }
                EndpointPair endpointPair = (EndpointPair)obj;
                return AbstractGraph.this.isDirected() == endpointPair.isOrdered() && AbstractGraph.this.nodes().contains(endpointPair.nodeU()) && AbstractGraph.this.successors(endpointPair.nodeU()).contains(endpointPair.nodeV());
            }
        };
    }

    @Override
    public int degree(Object node2) {
        if (this.isDirected()) {
            return IntMath.saturatedAdd(this.predecessors(node2).size(), this.successors(node2).size());
        }
        Set neighbors = this.adjacentNodes(node2);
        int selfLoopCount = this.allowsSelfLoops() && neighbors.contains(node2) ? 1 : 0;
        return IntMath.saturatedAdd(neighbors.size(), selfLoopCount);
    }

    @Override
    public int inDegree(Object node2) {
        return this.isDirected() ? this.predecessors(node2).size() : this.degree(node2);
    }

    @Override
    public int outDegree(Object node2) {
        return this.isDirected() ? this.successors(node2).size() : this.degree(node2);
    }

    public String toString() {
        String propertiesString = String.format("isDirected: %s, allowsSelfLoops: %s", this.isDirected(), this.allowsSelfLoops());
        return String.format("%s, nodes: %s, edges: %s", propertiesString, this.nodes(), this.edges());
    }
}

