/*
 * Decompiled with CFR 0.152.
 */
package net.weavemc.relocate.google.common.escape;

import net.weavemc.relocate.google.common.annotations.Beta;
import net.weavemc.relocate.google.common.annotations.GwtCompatible;
import net.weavemc.relocate.google.common.base.Preconditions;
import net.weavemc.relocate.google.common.escape.Escaper;
import net.weavemc.relocate.google.common.escape.Platform;

@Beta
@GwtCompatible
public abstract class CharEscaper
extends Escaper {
    private static final int DEST_PAD_MULTIPLIER = 2;

    protected CharEscaper() {
    }

    @Override
    public String escape(String string) {
        Preconditions.checkNotNull(string);
        int length = string.length();
        for (int index2 = 0; index2 < length; ++index2) {
            if (this.escape(string.charAt(index2)) == null) continue;
            return this.escapeSlow(string, index2);
        }
        return string;
    }

    protected final String escapeSlow(String s, int index2) {
        int slen = s.length();
        char[] dest = Platform.charBufferFromThreadLocal();
        int destSize = dest.length;
        int destIndex = 0;
        int lastEscape = 0;
        while (index2 < slen) {
            char[] r = this.escape(s.charAt(index2));
            if (r != null) {
                int charsSkipped = index2 - lastEscape;
                int rlen = r.length;
                int sizeNeeded = destIndex + charsSkipped + rlen;
                if (destSize < sizeNeeded) {
                    destSize = sizeNeeded + 2 * (slen - index2);
                    dest = CharEscaper.growBuffer(dest, destIndex, destSize);
                }
                if (charsSkipped > 0) {
                    s.getChars(lastEscape, index2, dest, destIndex);
                    destIndex += charsSkipped;
                }
                if (rlen > 0) {
                    System.arraycopy(r, 0, dest, destIndex, rlen);
                    destIndex += rlen;
                }
                lastEscape = index2 + 1;
            }
            ++index2;
        }
        int charsLeft = slen - lastEscape;
        if (charsLeft > 0) {
            int sizeNeeded = destIndex + charsLeft;
            if (destSize < sizeNeeded) {
                dest = CharEscaper.growBuffer(dest, destIndex, sizeNeeded);
            }
            s.getChars(lastEscape, slen, dest, destIndex);
            destIndex = sizeNeeded;
        }
        return new String(dest, 0, destIndex);
    }

    protected abstract char[] escape(char var1);

    private static char[] growBuffer(char[] dest, int index2, int size) {
        if (size < 0) {
            throw new AssertionError((Object)"Cannot increase internal buffer any further");
        }
        char[] copy = new char[size];
        if (index2 > 0) {
            System.arraycopy(dest, 0, copy, 0, index2);
        }
        return copy;
    }
}

