/*
 * Decompiled with CFR 0.152.
 */
package net.weavemc.relocate.google.common.collect;

import java.util.function.Consumer;
import net.weavemc.relocate.google.common.annotations.GwtCompatible;
import net.weavemc.relocate.google.common.annotations.GwtIncompatible;
import net.weavemc.relocate.google.common.collect.ImmutableAsList;
import net.weavemc.relocate.google.common.collect.ImmutableCollection;
import net.weavemc.relocate.google.common.collect.ImmutableList;
import net.weavemc.relocate.google.common.collect.UnmodifiableListIterator;

@GwtCompatible(emulated=true)
class RegularImmutableAsList<E>
extends ImmutableAsList<E> {
    private final ImmutableCollection<E> delegate;
    private final ImmutableList<? extends E> delegateList;

    RegularImmutableAsList(ImmutableCollection<E> delegate, ImmutableList<? extends E> delegateList) {
        this.delegate = delegate;
        this.delegateList = delegateList;
    }

    RegularImmutableAsList(ImmutableCollection<E> delegate, Object[] array) {
        this(delegate, ImmutableList.asImmutableList(array));
    }

    @Override
    ImmutableCollection<E> delegateCollection() {
        return this.delegate;
    }

    ImmutableList<? extends E> delegateList() {
        return this.delegateList;
    }

    @Override
    public UnmodifiableListIterator<E> listIterator(int index2) {
        return this.delegateList.listIterator(index2);
    }

    @Override
    @GwtIncompatible
    public void forEach(Consumer<? super E> action) {
        this.delegateList.forEach(action);
    }

    @Override
    @GwtIncompatible
    int copyIntoArray(Object[] dst, int offset) {
        return this.delegateList.copyIntoArray(dst, offset);
    }

    @Override
    public E get(int index2) {
        return this.delegateList.get(index2);
    }
}

