/*
 * Decompiled with CFR 0.152.
 */
package net.weavemc.relocate.google.common.collect;

import java.util.ArrayDeque;
import java.util.Collections;
import java.util.Queue;
import net.weavemc.relocate.google.common.annotations.GwtCompatible;
import net.weavemc.relocate.google.common.base.Preconditions;
import net.weavemc.relocate.google.common.collect.AbstractIterator;

@GwtCompatible
class ConsumingQueueIterator<T>
extends AbstractIterator<T> {
    private final Queue<T> queue;

    ConsumingQueueIterator(T ... elements) {
        this.queue = new ArrayDeque<T>(elements.length);
        Collections.addAll(this.queue, elements);
    }

    ConsumingQueueIterator(Queue<T> queue) {
        this.queue = Preconditions.checkNotNull(queue);
    }

    @Override
    public T computeNext() {
        return this.queue.isEmpty() ? this.endOfData() : this.queue.remove();
    }
}

