/*
 * Decompiled with CFR 0.152.
 */
package net.weavemc.relocate.google.common.collect;

import java.util.Comparator;
import java.util.Iterator;
import net.weavemc.relocate.google.common.annotations.Beta;
import net.weavemc.relocate.google.common.annotations.GwtCompatible;
import net.weavemc.relocate.google.common.base.Preconditions;
import net.weavemc.relocate.google.common.collect.LexicographicalOrdering;

@Beta
@GwtCompatible
public final class Comparators {
    private Comparators() {
    }

    public static <T, S extends T> Comparator<Iterable<S>> lexicographical(Comparator<T> comparator) {
        return new LexicographicalOrdering<T>(Preconditions.checkNotNull(comparator));
    }

    public static <T> boolean isInOrder(Iterable<? extends T> iterable, Comparator<T> comparator) {
        Preconditions.checkNotNull(comparator);
        Iterator<T> it = iterable.iterator();
        if (it.hasNext()) {
            T prev2 = it.next();
            while (it.hasNext()) {
                T next2 = it.next();
                if (comparator.compare(prev2, next2) > 0) {
                    return false;
                }
                prev2 = next2;
            }
        }
        return true;
    }

    public static <T> boolean isInStrictOrder(Iterable<? extends T> iterable, Comparator<T> comparator) {
        Preconditions.checkNotNull(comparator);
        Iterator<T> it = iterable.iterator();
        if (it.hasNext()) {
            T prev2 = it.next();
            while (it.hasNext()) {
                T next2 = it.next();
                if (comparator.compare(prev2, next2) >= 0) {
                    return false;
                }
                prev2 = next2;
            }
        }
        return true;
    }
}

