/*
 * Decompiled with CFR 0.152.
 */
package net.weavemc.relocate.asm.util;

import java.io.PrintWriter;
import net.weavemc.relocate.asm.AnnotationVisitor;
import net.weavemc.relocate.asm.Attribute;
import net.weavemc.relocate.asm.ClassVisitor;
import net.weavemc.relocate.asm.FieldVisitor;
import net.weavemc.relocate.asm.MethodVisitor;
import net.weavemc.relocate.asm.ModuleVisitor;
import net.weavemc.relocate.asm.RecordComponentVisitor;
import net.weavemc.relocate.asm.TypePath;
import net.weavemc.relocate.asm.util.Printer;
import net.weavemc.relocate.asm.util.Textifier;
import net.weavemc.relocate.asm.util.TraceAnnotationVisitor;
import net.weavemc.relocate.asm.util.TraceFieldVisitor;
import net.weavemc.relocate.asm.util.TraceMethodVisitor;
import net.weavemc.relocate.asm.util.TraceModuleVisitor;
import net.weavemc.relocate.asm.util.TraceRecordComponentVisitor;

public final class TraceClassVisitor
extends ClassVisitor {
    private final PrintWriter printWriter;
    public final Printer p;

    public TraceClassVisitor(PrintWriter printWriter) {
        this(null, printWriter);
    }

    public TraceClassVisitor(ClassVisitor classVisitor, PrintWriter printWriter) {
        this(classVisitor, new Textifier(), printWriter);
    }

    public TraceClassVisitor(ClassVisitor classVisitor, Printer printer, PrintWriter printWriter) {
        super(0x10A0000, classVisitor);
        this.printWriter = printWriter;
        this.p = printer;
    }

    public void visit(int version2, int access, String name, String signature, String superName, String[] interfaces) {
        this.p.visit(version2, access, name, signature, superName, interfaces);
        super.visit(version2, access, name, signature, superName, interfaces);
    }

    public void visitSource(String file, String debug) {
        this.p.visitSource(file, debug);
        super.visitSource(file, debug);
    }

    public ModuleVisitor visitModule(String name, int flags, String version2) {
        Printer modulePrinter = this.p.visitModule(name, flags, version2);
        return new TraceModuleVisitor(super.visitModule(name, flags, version2), modulePrinter);
    }

    public void visitNestHost(String nestHost) {
        this.p.visitNestHost(nestHost);
        super.visitNestHost(nestHost);
    }

    public void visitOuterClass(String owner, String name, String descriptor2) {
        this.p.visitOuterClass(owner, name, descriptor2);
        super.visitOuterClass(owner, name, descriptor2);
    }

    public AnnotationVisitor visitAnnotation(String descriptor2, boolean visible) {
        Printer annotationPrinter = this.p.visitClassAnnotation(descriptor2, visible);
        return new TraceAnnotationVisitor(super.visitAnnotation(descriptor2, visible), annotationPrinter);
    }

    public AnnotationVisitor visitTypeAnnotation(int typeRef, TypePath typePath, String descriptor2, boolean visible) {
        Printer annotationPrinter = this.p.visitClassTypeAnnotation(typeRef, typePath, descriptor2, visible);
        return new TraceAnnotationVisitor(super.visitTypeAnnotation(typeRef, typePath, descriptor2, visible), annotationPrinter);
    }

    public void visitAttribute(Attribute attribute) {
        this.p.visitClassAttribute(attribute);
        super.visitAttribute(attribute);
    }

    public void visitNestMember(String nestMember) {
        this.p.visitNestMember(nestMember);
        super.visitNestMember(nestMember);
    }

    public void visitPermittedSubclass(String permittedSubclass) {
        this.p.visitPermittedSubclass(permittedSubclass);
        super.visitPermittedSubclass(permittedSubclass);
    }

    public void visitInnerClass(String name, String outerName, String innerName, int access) {
        this.p.visitInnerClass(name, outerName, innerName, access);
        super.visitInnerClass(name, outerName, innerName, access);
    }

    public RecordComponentVisitor visitRecordComponent(String name, String descriptor2, String signature) {
        Printer recordComponentPrinter = this.p.visitRecordComponent(name, descriptor2, signature);
        return new TraceRecordComponentVisitor(super.visitRecordComponent(name, descriptor2, signature), recordComponentPrinter);
    }

    public FieldVisitor visitField(int access, String name, String descriptor2, String signature, Object value) {
        Printer fieldPrinter = this.p.visitField(access, name, descriptor2, signature, value);
        return new TraceFieldVisitor(super.visitField(access, name, descriptor2, signature, value), fieldPrinter);
    }

    public MethodVisitor visitMethod(int access, String name, String descriptor2, String signature, String[] exceptions) {
        Printer methodPrinter = this.p.visitMethod(access, name, descriptor2, signature, exceptions);
        return new TraceMethodVisitor(super.visitMethod(access, name, descriptor2, signature, exceptions), methodPrinter);
    }

    public void visitEnd() {
        this.p.visitClassEnd();
        if (this.printWriter != null) {
            this.p.print(this.printWriter);
            this.printWriter.flush();
        }
        super.visitEnd();
    }
}

