/*
 * Decompiled with CFR 0.152.
 */
package net.weavemc.loader.util;

import com.grappenmaker.mappings.Mappings;
import java.io.File;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.security.MessageDigest;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import javax.swing.JOptionPane;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.io.ByteStreamsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import kotlinx.serialization.DeserializationStrategy;
import kotlinx.serialization.json.Json;
import kotlinx.serialization.json.JsonKt;
import net.weavemc.internals.GameInfo;
import net.weavemc.internals.ModConfig;
import net.weavemc.loader.util.FileManager;
import net.weavemc.loader.util.MappingsHandler;
import net.weavemc.loader.util.MultiMCComponent;
import net.weavemc.loader.util.MultiMCInstance;
import net.weavemc.loader.util.UtilityKt;
import net.weavemc.relocate.asm.ClassReader;
import net.weavemc.relocate.asm.tree.AnnotationNode;
import net.weavemc.relocate.asm.tree.ClassNode;
import net.weavemc.relocate.asm.tree.MethodNode;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000`\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0001\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0004\u001a\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0006H\u0000\u001a\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0006H\u0000\u001a\u001e\u0010\u000f\u001a\u0002H\u0010\"\u0006\b\u0000\u0010\u0010\u0018\u00012\u0006\u0010\u0011\u001a\u00020\u0006H\u0086\b\u00a2\u0006\u0002\u0010\u0012\u001a\b\u0010\u0013\u001a\u00020\u0014H\u0000\u001a\f\u0010\u0015\u001a\u00020\u0016*\u00020\u0017H\u0000\u001a\f\u0010\u0018\u001a\u00020\u0017*\u00020\u0019H\u0000\u001a\n\u0010\u001a\u001a\u00020\u001b*\u00020\u001c\u001a\u001a\u0010\u001d\u001a\u00020\u001e*\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u00062\u0006\u0010 \u001a\u00020\u001b\u001a\u0012\u0010!\u001a\u00020\u001b*\u00020\u001c2\u0006\u0010\"\u001a\u00020\u0001\u001a\u0012\u0010#\u001a\u00020$*\u00020%2\u0006\u0010\u001f\u001a\u00020\u0006\u001a.\u0010&\u001a\b\u0012\u0004\u0012\u0002H\u00100'\"\u0006\b\u0000\u0010\u0010\u0018\u0001*\b\u0012\u0004\u0012\u0002H\u00100\u00052\u0006\u0010(\u001a\u0002H\u0010H\u0080\b\u00a2\u0006\u0002\u0010)\u001a\f\u0010*\u001a\u00020\u0006*\u00020\u001eH\u0000\"\u0014\u0010\u0000\u001a\u00020\u0001X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0002\u0010\u0003\"\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006+"}, d2={"JSON", "Lkotlinx/serialization/json/Json;", "getJSON", "()Lkotlinx/serialization/json/Json;", "illegalToReload", "", "", "getIllegalToReload", "()Ljava/util/Set;", "fatalError", "", "message", "getOrCreateDirectory", "Ljava/nio/file/Path;", "directory", "instantiate", "T", "className", "(Ljava/lang/String;)Ljava/lang/Object;", "setGameInfo", "", "asClassNode", "Lorg/objectweb/asm/tree/ClassNode;", "Lorg/objectweb/asm/ClassReader;", "asClassReader", "", "configOrFatal", "Lnet/weavemc/internals/ModConfig;", "Ljava/util/jar/JarFile;", "createRemappedTemp", "Ljava/io/File;", "name", "config", "fetchModConfig", "json", "hasMixinAnnotation", "", "Lorg/objectweb/asm/tree/MethodNode;", "pushToFirst", "", "element", "(Ljava/util/Set;Ljava/lang/Object;)Ljava/util/List;", "toSha256", "loader"})
@SourceDebugExtension(value={"SMAP\nUtility.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Utility.kt\nnet/weavemc/loader/util/UtilityKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 Json.kt\nkotlinx/serialization/json/Json\n*L\n1#1,207:1\n1#2:208\n1747#3,3:209\n96#4:212\n96#4:213\n*S KotlinDebug\n*F\n+ 1 Utility.kt\nnet/weavemc/loader/util/UtilityKt\n*L\n123#1:209,3\n152#1:212\n175#1:213\n*E\n"})
public final class UtilityKt {
    @NotNull
    private static final Json JSON = JsonKt.Json$default(null, JSON.1.INSTANCE, 1, null);
    @NotNull
    private static final Set<String> illegalToReload;

    @NotNull
    public static final Path getOrCreateDirectory(@NotNull String directory) {
        Intrinsics.checkNotNullParameter(directory, "directory");
        String[] stringArray = new String[]{".weave", directory};
        Path dir = Paths.get(System.getProperty("user.home"), stringArray);
        Intrinsics.checkNotNull(dir);
        LinkOption[] linkOptionArray = new LinkOption[]{};
        if (Files.exists(dir, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
            LinkOption[] linkOptionArray2 = new LinkOption[]{};
            if (!Files.isDirectory(dir, Arrays.copyOf(linkOptionArray2, linkOptionArray2.length))) {
                Files.delete(dir);
            }
        }
        LinkOption[] linkOptionArray3 = new LinkOption[]{};
        if (!Files.exists(dir, Arrays.copyOf(linkOptionArray3, linkOptionArray3.length))) {
            FileAttribute[] fileAttributeArray = new FileAttribute[]{};
            Intrinsics.checkNotNullExpressionValue(Files.createDirectories(dir, Arrays.copyOf(fileAttributeArray, fileAttributeArray.length)), "createDirectories(...)");
        }
        return dir;
    }

    @NotNull
    public static final ClassReader asClassReader(@NotNull byte[] $this$asClassReader) {
        Intrinsics.checkNotNullParameter($this$asClassReader, "<this>");
        return new ClassReader($this$asClassReader);
    }

    @NotNull
    public static final ClassNode asClassNode(@NotNull ClassReader $this$asClassNode) {
        ClassNode classNode;
        Intrinsics.checkNotNullParameter($this$asClassNode, "<this>");
        ClassNode it = classNode = new ClassNode();
        boolean bl = false;
        $this$asClassNode.accept(it, 0);
        return classNode;
    }

    @NotNull
    public static final String toSha256(@NotNull File $this$toSha256) {
        Intrinsics.checkNotNullParameter($this$toSha256, "<this>");
        byte[] bytes = Files.readAllBytes($this$toSha256.toPath());
        MessageDigest messageDigest = MessageDigest.getInstance("SHA-256");
        byte[] digest = messageDigest.digest(bytes);
        Intrinsics.checkNotNull(digest);
        return ArraysKt.joinToString$default(digest, (CharSequence)"", null, null, 0, null, (Function1)toSha256.1.INSTANCE, 30, null);
    }

    @NotNull
    public static final Json getJSON() {
        return JSON;
    }

    public static final /* synthetic */ <T> List<T> pushToFirst(Set<? extends T> $this$pushToFirst, T element) {
        T t;
        Intrinsics.checkNotNullParameter($this$pushToFirst, "<this>");
        boolean $i$f$pushToFirst = false;
        T it = t = element;
        boolean bl = false;
        return CollectionsKt.plus((Collection)CollectionsKt.listOfNotNull($this$pushToFirst.contains(it) ? t : null), (Iterable)SetsKt.minus($this$pushToFirst, element));
    }

    public static final boolean hasMixinAnnotation(@NotNull MethodNode $this$hasMixinAnnotation, @NotNull String name) {
        boolean bl;
        Intrinsics.checkNotNullParameter($this$hasMixinAnnotation, "<this>");
        Intrinsics.checkNotNullParameter(name, "name");
        String annotation = "spongepowered/asm/mixin/transformer/meta/" + name + ';';
        List<AnnotationNode> list = $this$hasMixinAnnotation.visibleAnnotations;
        if (list != null) {
            boolean bl2;
            block5: {
                Iterable $this$any$iv = list;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl2 = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        AnnotationNode it = (AnnotationNode)element$iv;
                        boolean bl3 = false;
                        String string = it.desc;
                        Intrinsics.checkNotNullExpressionValue(string, "desc");
                        if (!StringsKt.endsWith$default(string, annotation, false, 2, null)) continue;
                        bl2 = true;
                        break block5;
                    }
                    bl2 = false;
                }
            }
            bl = bl2;
        } else {
            bl = false;
        }
        return bl;
    }

    public static final /* synthetic */ <T> T instantiate(String className) {
        Intrinsics.checkNotNullParameter(className, "className");
        boolean $i$f$instantiate = false;
        Object obj = Class.forName(className).getConstructor(new Class[0]).newInstance(new Object[0]);
        Intrinsics.reifiedOperationMarker(2, "T");
        if (obj == null) {
            StringBuilder stringBuilder = new StringBuilder().append(className).append(" does not implement ");
            Intrinsics.reifiedOperationMarker(4, "T");
            throw new IllegalStateException(stringBuilder.append(Object.class.getSimpleName()).append('!').toString().toString());
        }
        return (T)obj;
    }

    @NotNull
    public static final Void fatalError(@NotNull String message) {
        Intrinsics.checkNotNullParameter(message, "message");
        JOptionPane.showMessageDialog(null, "An error occurred: " + message, "Weave Loader error", 0);
        System.exit(-1);
        throw new RuntimeException("System.exit returned normally, while it was supposed to halt JVM.");
    }

    @NotNull
    public static final ModConfig configOrFatal(@NotNull JarFile $this$configOrFatal) {
        Object object;
        Intrinsics.checkNotNullParameter($this$configOrFatal, "<this>");
        Object object2 = $this$configOrFatal;
        try {
            JarFile $this$configOrFatal_u24lambda_u243 = object2;
            boolean bl = false;
            object = Result.constructor-impl(UtilityKt.fetchModConfig($this$configOrFatal_u24lambda_u243, JSON));
        }
        catch (Throwable bl) {
            object = Result.constructor-impl(ResultKt.createFailure(bl));
        }
        object2 = object;
        Throwable throwable = Result.exceptionOrNull-impl(object2);
        if (throwable != null) {
            Object it = object = throwable;
            boolean bl = false;
            System.out.println((Object)"Possibly non-weave mod failed to load:");
            ((Throwable)it).printStackTrace();
            UtilityKt.fatalError("Mod file " + $this$configOrFatal.getName() + " is possibly not a Weave mod!");
            throw new KotlinNothingValueException();
        }
        ResultKt.throwOnFailure(object2);
        return (ModConfig)object2;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final ModConfig fetchModConfig(@NotNull JarFile $this$fetchModConfig, @NotNull Json json2) {
        void this_$iv;
        Intrinsics.checkNotNullParameter($this$fetchModConfig, "<this>");
        Intrinsics.checkNotNullParameter(json2, "json");
        ZipEntry zipEntry = $this$fetchModConfig.getEntry("weave.mod.json");
        if (zipEntry == null) {
            throw new IllegalStateException(($this$fetchModConfig.getName() + " does not contain a weave.mod.json!").toString());
        }
        ZipEntry configEntry = zipEntry;
        Json json3 = json2;
        InputStream inputStream = $this$fetchModConfig.getInputStream(configEntry);
        Intrinsics.checkNotNullExpressionValue(inputStream, "getInputStream(...)");
        String string$iv = StringsKt.decodeToString(ByteStreamsKt.readBytes(inputStream));
        boolean $i$f$decodeFromString = false;
        this_$iv.getSerializersModule();
        return (ModConfig)this_$iv.decodeFromString((DeserializationStrategy)ModConfig.Companion.serializer(), string$iv);
    }

    @NotNull
    public static final File createRemappedTemp(@NotNull File $this$createRemappedTemp, @NotNull String name, @NotNull ModConfig config) {
        Intrinsics.checkNotNullParameter($this$createRemappedTemp, "<this>");
        Intrinsics.checkNotNullParameter(name, "name");
        Intrinsics.checkNotNullParameter(config, "config");
        File temp = File.createTempFile(name, "-weavemod.jar");
        MappingsHandler mappingsHandler = MappingsHandler.INSTANCE;
        Mappings mappings = MappingsHandler.INSTANCE.getMergedMappings().getMappings();
        List<File> list = CollectionsKt.listOf(FileManager.INSTANCE.getVanillaMinecraftJar());
        String string = config.getNamespace();
        Intrinsics.checkNotNull(temp);
        MappingsHandler.remapModJar$default(mappingsHandler, mappings, $this$createRemappedTemp, temp, string, null, list, 16, null);
        temp.deleteOnExit();
        return temp;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static final void setGameInfo() {
        Object object;
        Object object2;
        Object object3;
        block7: {
            String string;
            block8: {
                String string2 = System.getProperty("user.dir");
                Intrinsics.checkNotNullExpressionValue(string2, "getProperty(...)");
                Path path = Paths.get(string2, new String[0]);
                Intrinsics.checkNotNullExpressionValue(path, "get(...)");
                Path cwd = path;
                string = System.getProperty("weave.environment.version");
                if (string != null) break block8;
                if (StringsKt.contains$default((CharSequence)((Object)cwd).toString(), "instances", false, 2, null)) {
                    Object v3;
                    Path instance;
                    block6: {
                        instance = cwd.getParent();
                        Json json2 = JSON;
                        File file = instance.resolve("mmc-pack.json").toFile();
                        Intrinsics.checkNotNullExpressionValue(file, "toFile(...)");
                        String string$iv = FilesKt.readText$default(file, null, 1, null);
                        boolean $i$f$decodeFromString = false;
                        json2.getSerializersModule();
                        MultiMCInstance instanceData = (MultiMCInstance)json2.decodeFromString((DeserializationStrategy)MultiMCInstance.Companion.serializer(), string$iv);
                        Iterable iterable = instanceData.getComponents();
                        for (Object t : iterable) {
                            MultiMCComponent it = (MultiMCComponent)t;
                            boolean bl = false;
                            if (!Intrinsics.areEqual(it.getUid(), "net.minecraft")) continue;
                            v3 = t;
                            break block6;
                        }
                        v3 = null;
                    }
                    if ((object3 = (MultiMCComponent)v3) == null || (object3 = ((MultiMCComponent)object3).getVersion()) == null) {
                        StringBuilder stringBuilder = new StringBuilder().append("Failed to find \"Minecraft\" component in ");
                        Intrinsics.checkNotNull(instance);
                        UtilityKt.fatalError(stringBuilder.append(((Object)instance).toString()).append("'s mmc-pack.json").toString());
                        throw new KotlinNothingValueException();
                    }
                    break block7;
                } else {
                    String string3;
                    Regex regex = new Regex("--version\\s+(\\S+)");
                    String string4 = System.getProperty("sun.java.command");
                    Intrinsics.checkNotNullExpressionValue(string4, "getProperty(...)");
                    object2 = Regex.find$default(regex, string4, 0, 2, null);
                    if (object2 != null && (object = object2.getGroupValues()) != null && (string3 = (String)object.get(1)) != null) {
                        object3 = string3;
                        break block7;
                    } else {
                        UtilityKt.fatalError("Could not parse version from command line arguments");
                        throw new KotlinNothingValueException();
                    }
                }
            }
            object3 = string;
        }
        String version2 = object3;
        String client2 = UtilityKt.setGameInfo$classExists("com.moonsworth.lunar.genesis.Genesis") ? "lunar client" : (UtilityKt.setGameInfo$classExists("net.minecraftforge.fml.common.Loader") ? "forge" : (StringsKt.contains$default((CharSequence)GameInfo.INSTANCE.getCommandLineArgs(), "labymod", false, 2, null) ? "labymod" : "vanilla"));
        Properties properties = System.getProperties();
        Intrinsics.checkNotNullExpressionValue(properties, "getProperties(...)");
        object2 = properties;
        object = "weave.game.info";
        Pair[] pairArray = new Pair[]{TuplesKt.to("version", version2), TuplesKt.to("client", client2)};
        Map map = MapsKt.mapOf(pairArray);
        object2.put(object, map);
    }

    @NotNull
    public static final Set<String> getIllegalToReload() {
        return illegalToReload;
    }

    private static final boolean setGameInfo$classExists(String name) {
        return GameInfo.class.getClassLoader().getResourceAsStream(StringsKt.replace$default(name, '.', '/', false, 4, null) + ".class") != null;
    }

    static {
        String[] stringArray = new String[]{"java.", "javax.", "org.xml.", "org.w3c.", "sun.", "jdk.", "com.sun.management.", "org.apache.", "org.slf4j."};
        illegalToReload = SetsKt.setOf(stringArray);
    }
}

