/*
 * Decompiled with CFR 0.152.
 */
package net.weavemc.loader.util;

import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.path.PathsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import net.weavemc.internals.GameInfo;
import net.weavemc.loader.util.UtilityKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u00c0\u0002\u0018\u00002\u00020\u0001:\u0001\u0011B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nJ\u0006\u0010\f\u001a\u00020\rJ\u001c\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000b0\n*\u00020\u00042\b\b\u0002\u0010\u000f\u001a\u00020\u0010H\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006\u00a8\u0006\u0012"}, d2={"Lnet/weavemc/loader/util/FileManager;", "", "()V", "DUMP_DIRECTORY", "Ljava/nio/file/Path;", "getDUMP_DIRECTORY", "()Ljava/nio/file/Path;", "MODS_DIRECTORY", "getMODS_DIRECTORY", "getMods", "", "Lnet/weavemc/loader/util/FileManager$ModJar;", "getVanillaMinecraftJar", "Ljava/io/File;", "walkMods", "isSpecific", "", "ModJar", "loader"})
@SourceDebugExtension(value={"SMAP\nFileManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FileManager.kt\nnet/weavemc/loader/util/FileManager\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,49:1\n766#2:50\n857#2,2:51\n1549#2:53\n1620#2,3:54\n*S KotlinDebug\n*F\n+ 1 FileManager.kt\nnet/weavemc/loader/util/FileManager\n*L\n44#1:50\n44#1:51,2\n45#1:53\n45#1:54,3\n*E\n"})
public final class FileManager {
    @NotNull
    public static final FileManager INSTANCE = new FileManager();
    @NotNull
    private static final Path MODS_DIRECTORY = UtilityKt.getOrCreateDirectory("mods");
    @NotNull
    private static final Path DUMP_DIRECTORY = UtilityKt.getOrCreateDirectory(".bytecode.out");

    private FileManager() {
    }

    @NotNull
    public final Path getMODS_DIRECTORY() {
        return MODS_DIRECTORY;
    }

    @NotNull
    public final Path getDUMP_DIRECTORY() {
        return DUMP_DIRECTORY;
    }

    @NotNull
    public final File getVanillaMinecraftJar() {
        String string;
        String string2 = System.getProperty("os.name");
        Intrinsics.checkNotNullExpressionValue(string2, "getProperty(...)");
        String string3 = string2.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue(string3, "toLowerCase(...)");
        String os = string3;
        String string4 = System.getProperty("user.home");
        String[] stringArray = new String[1];
        if (StringsKt.contains$default((CharSequence)os, "win", false, 2, null)) {
            string = "AppData" + File.separator + "Roaming" + File.separator + ".minecraft";
        } else if (StringsKt.contains$default((CharSequence)os, "mac", false, 2, null)) {
            string = "Library" + File.separator + "Application Support" + File.separator + "minecraft";
        } else if (StringsKt.contains$default((CharSequence)os, "nix", false, 2, null) || StringsKt.contains$default((CharSequence)os, "nux", false, 2, null) || StringsKt.contains$default((CharSequence)os, "aix", false, 2, null)) {
            string = ".minecraft";
        } else {
            throw new IllegalStateException("Failed to retrieve Vanilla Minecraft Jar due to unsupported OS.".toString());
        }
        stringArray[0] = string;
        Path minecraftPath = Paths.get(string4, stringArray);
        File file = minecraftPath.resolve("versions").resolve(GameInfo.INSTANCE.getVersion().getVersionName()).resolve(GameInfo.INSTANCE.getVersion().getVersionName() + ".jar").toFile();
        Intrinsics.checkNotNullExpressionValue(file, "toFile(...)");
        return file;
    }

    @NotNull
    public final List<ModJar> getMods() {
        List mods = new ArrayList();
        CollectionsKt.addAll((Collection)mods, FileManager.walkMods$default(this, MODS_DIRECTORY, false, 1, null));
        Path specificVersionDirectory = MODS_DIRECTORY.resolve(GameInfo.INSTANCE.getVersion().getVersionName());
        Intrinsics.checkNotNull(specificVersionDirectory);
        LinkOption[] linkOptionArray = new LinkOption[]{};
        if (Files.exists(specificVersionDirectory, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
            LinkOption[] linkOptionArray2 = new LinkOption[]{};
            if (Files.isDirectory(specificVersionDirectory, Arrays.copyOf(linkOptionArray2, linkOptionArray2.length))) {
                CollectionsKt.addAll((Collection)mods, (Iterable)this.walkMods(specificVersionDirectory, true));
            }
        }
        return mods;
    }

    /*
     * WARNING - void declaration
     */
    private final List<ModJar> walkMods(Path $this$walkMods, boolean isSpecific) {
        void $this$mapTo$iv$iv;
        Path it;
        Iterable $this$filterTo$iv$iv;
        Iterable $this$filter$iv = PathsKt.listDirectoryEntries($this$walkMods, "*.jar");
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (Path)element$iv$iv;
            boolean bl = false;
            LinkOption[] linkOptionArray = new LinkOption[]{};
            if (!Files.isRegularFile(it, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (Path)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            File file = it.toFile();
            Intrinsics.checkNotNullExpressionValue(file, "toFile(...)");
            collection.add(new ModJar(file, isSpecific));
        }
        return (List)destination$iv$iv;
    }

    static /* synthetic */ List walkMods$default(FileManager fileManager, Path path, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = false;
        }
        return fileManager.walkMods(path, bl);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\n\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\n\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000b\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\f\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\r\u001a\u00020\u00052\b\u0010\u000e\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u000f\u001a\u00020\u0010H\u00d6\u0001J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0004\u0010\t\u00a8\u0006\u0013"}, d2={"Lnet/weavemc/loader/util/FileManager$ModJar;", "", "file", "Ljava/io/File;", "isSpecific", "", "(Ljava/io/File;Z)V", "getFile", "()Ljava/io/File;", "()Z", "component1", "component2", "copy", "equals", "other", "hashCode", "", "toString", "", "loader"})
    public static final class ModJar {
        @NotNull
        private final File file;
        private final boolean isSpecific;

        public ModJar(@NotNull File file, boolean isSpecific) {
            Intrinsics.checkNotNullParameter(file, "file");
            this.file = file;
            this.isSpecific = isSpecific;
        }

        @NotNull
        public final File getFile() {
            return this.file;
        }

        public final boolean isSpecific() {
            return this.isSpecific;
        }

        @NotNull
        public final File component1() {
            return this.file;
        }

        public final boolean component2() {
            return this.isSpecific;
        }

        @NotNull
        public final ModJar copy(@NotNull File file, boolean isSpecific) {
            Intrinsics.checkNotNullParameter(file, "file");
            return new ModJar(file, isSpecific);
        }

        public static /* synthetic */ ModJar copy$default(ModJar modJar, File file, boolean bl, int n, Object object) {
            if ((n & 1) != 0) {
                file = modJar.file;
            }
            if ((n & 2) != 0) {
                bl = modJar.isSpecific;
            }
            return modJar.copy(file, bl);
        }

        @NotNull
        public String toString() {
            return "ModJar(file=" + this.file + ", isSpecific=" + this.isSpecific + ')';
        }

        public int hashCode() {
            int result = this.file.hashCode();
            int n = this.isSpecific ? 1 : 0;
            if (n != 0) {
                n = 1;
            }
            result = result * 31 + n;
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ModJar)) {
                return false;
            }
            ModJar modJar = (ModJar)other;
            if (!Intrinsics.areEqual(this.file, modJar.file)) {
                return false;
            }
            return this.isSpecific == modJar.isSpecific;
        }
    }
}

