/*
 * Decompiled with CFR 0.152.
 */
package net.weavemc.loader.util;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.io.ByteStreamsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import net.weavemc.loader.util.DownloadUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u001e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\u0006J\u0018\u0010\f\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0006H\u0002J\u0016\u0010\f\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\u0004J\u0012\u0010\r\u001a\u0004\u0018\u00010\u00042\u0006\u0010\t\u001a\u00020\nH\u0002J\u0010\u0010\r\u001a\u0004\u0018\u00010\u00042\u0006\u0010\t\u001a\u00020\u0004\u00a8\u0006\u000e"}, d2={"Lnet/weavemc/loader/util/DownloadUtil;", "", "()V", "checksum", "", "file", "Ljava/nio/file/Path;", "checksumAndDownload", "", "url", "Ljava/net/URL;", "path", "download", "fetch", "loader"})
@SourceDebugExtension(value={"SMAP\nUtility.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Utility.kt\nnet/weavemc/loader/util/DownloadUtil\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,207:1\n1#2:208\n*E\n"})
public final class DownloadUtil {
    @NotNull
    public static final DownloadUtil INSTANCE = new DownloadUtil();

    private DownloadUtil() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final String checksum(Path file) {
        String string;
        try {
            String string2;
            LinkOption[] linkOptionArray = new LinkOption[]{};
            if (!Files.exists(file, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
                string2 = null;
            } else {
                MessageDigest digest = MessageDigest.getInstance("SHA-1");
                OpenOption[] openOptionArray = new OpenOption[]{};
                InputStream inputStream = Files.newInputStream(file, Arrays.copyOf(openOptionArray, openOptionArray.length));
                Intrinsics.checkNotNullExpressionValue(inputStream, "newInputStream(...)");
                Closeable closeable = inputStream;
                Throwable throwable = null;
                try {
                    InputStream input = (InputStream)closeable;
                    boolean bl = false;
                    byte[] buffer = new byte[8192];
                    int read = 0;
                    while (true) {
                        int n;
                        int it = n = input.read(buffer);
                        boolean bl2 = false;
                        read = it;
                        if (n < 0) break;
                        digest.update(buffer, 0, read);
                    }
                    Unit unit = Unit.INSTANCE;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally(closeable, throwable);
                }
                byte[] byArray = digest.digest();
                Intrinsics.checkNotNullExpressionValue(byArray, "digest(...)");
                string2 = ArraysKt.joinToString$default(byArray, null, null, null, 0, null, (Function1)checksum.2.INSTANCE, 31, null);
            }
            string = string2;
        }
        catch (IOException ex) {
            ex.printStackTrace();
            string = null;
        }
        catch (NoSuchAlgorithmException ignored) {
            string = null;
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void download(URL url, Path path) {
        block8: {
            Object object;
            Object object2 = this;
            try {
                long l;
                DownloadUtil $this$download_u24lambda_u243 = object2;
                boolean bl = false;
                Closeable closeable = url.openStream();
                Throwable throwable = null;
                try {
                    InputStream input = (InputStream)closeable;
                    boolean bl2 = false;
                    Files.createDirectories(path.getParent(), new FileAttribute[0]);
                    CopyOption[] copyOptionArray = new CopyOption[]{StandardCopyOption.REPLACE_EXISTING};
                    l = Files.copy(input, path, copyOptionArray);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally(closeable, throwable);
                }
                object = Result.constructor-impl(l);
            }
            catch (Throwable bl) {
                object = Result.constructor-impl(ResultKt.createFailure(bl));
            }
            object2 = object;
            Throwable throwable = Result.exceptionOrNull-impl(object2);
            if (throwable == null) break block8;
            Object it = object = throwable;
            boolean bl = false;
            ((Throwable)it).printStackTrace();
        }
    }

    public final void download(@NotNull String url, @NotNull String path) {
        Intrinsics.checkNotNullParameter(url, "url");
        Intrinsics.checkNotNullParameter(path, "path");
        URL uRL = new URL(url);
        Path path2 = Paths.get(path, new String[0]);
        Intrinsics.checkNotNullExpressionValue(path2, "get(...)");
        this.download(uRL, path2);
    }

    private final String fetch(URL url) {
        Object object;
        block2: {
            Object object2;
            object = this;
            try {
                DownloadUtil $this$fetch_u24lambda_u245 = object;
                boolean bl = false;
                InputStream inputStream = url.openStream();
                Intrinsics.checkNotNullExpressionValue(inputStream, "openStream(...)");
                object2 = Result.constructor-impl(StringsKt.decodeToString(ByteStreamsKt.readBytes(inputStream)));
            }
            catch (Throwable bl) {
                object2 = Result.constructor-impl(ResultKt.createFailure(bl));
            }
            object = object2;
            Throwable throwable = Result.exceptionOrNull-impl(object);
            if (throwable == null) break block2;
            Object it = object2 = throwable;
            boolean bl = false;
            ((Throwable)it).printStackTrace();
        }
        return (String)(Result.isFailure-impl(object) ? null : object);
    }

    @Nullable
    public final String fetch(@NotNull String url) {
        Intrinsics.checkNotNullParameter(url, "url");
        return this.fetch(new URL(url));
    }

    public final void checksumAndDownload(@NotNull URL url, @NotNull String checksum2, @NotNull Path path) {
        Intrinsics.checkNotNullParameter(url, "url");
        Intrinsics.checkNotNullParameter(checksum2, "checksum");
        Intrinsics.checkNotNullParameter(path, "path");
        if (!Intrinsics.areEqual(this.checksum(path), checksum2)) {
            this.download(url, path);
        }
    }
}

