/*
 * Decompiled with CFR 0.152.
 */
package net.weavemc.loader.mixin;

import java.io.InputStream;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.ByteStreamsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.weavemc.loader.util.UtilityKt;
import net.weavemc.relocate.asm.ClassReader;
import net.weavemc.relocate.asm.ClassWriter;
import net.weavemc.relocate.asm.tree.ClassNode;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0003\u0018\u00002\u00020\u0001B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\b\u0010\u000e\u001a\u00020\u0003H\u0014J\u0018\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u0010H\u0014J\u001a\u0010\u0013\u001a\u0010\u0012\f\u0012\n \u0015*\u0004\u0018\u00010\u00100\u00100\u0014*\u00020\fH\u0002J\u0012\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00100\u0014*\u00020\fH\u0002J\u000e\u0010\u0017\u001a\u0004\u0018\u00010\f*\u00020\u0010H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u000b\u001a\u00020\t*\u00020\f8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\r\u00a8\u0006\u0002"}, d2={"Lnet/weavemc/loader/mixin/LoaderClassWriter;", "Lorg/objectweb/asm/ClassWriter;", "loader", "Ljava/lang/ClassLoader;", "reader", "Lorg/objectweb/asm/ClassReader;", "flags", "", "useBytecodeInheritance", "", "(Ljava/lang/ClassLoader;Lorg/objectweb/asm/ClassReader;IZ)V", "isInterface", "Lorg/objectweb/asm/tree/ClassNode;", "(Lorg/objectweb/asm/tree/ClassNode;)Z", "getClassLoader", "getCommonSuperClass", "", "type1", "type2", "getAllParents", "", "kotlin.jvm.PlatformType", "getParents", "load"})
public final class LoaderClassWriter
extends ClassWriter {
    @NotNull
    private final ClassLoader loader;
    private final boolean useBytecodeInheritance;

    public LoaderClassWriter(@NotNull ClassLoader loader, @Nullable ClassReader reader, int flags, boolean useBytecodeInheritance) {
        Intrinsics.checkNotNullParameter(loader, "loader");
        super(reader, flags);
        this.loader = loader;
        this.useBytecodeInheritance = useBytecodeInheritance;
    }

    public /* synthetic */ LoaderClassWriter(ClassLoader classLoader, ClassReader classReader, int n, boolean bl, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            classReader = null;
        }
        if ((n2 & 4) != 0) {
            n = 0;
        }
        if ((n2 & 8) != 0) {
            bl = true;
        }
        this(classLoader, classReader, n, bl);
    }

    @Override
    @NotNull
    protected ClassLoader getClassLoader() {
        return this.loader;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final ClassNode load(String $this$load) {
        InputStream inputStream = this.loader.getResourceAsStream($this$load + ".class");
        Object object = inputStream;
        if (inputStream == null) return null;
        byte[] byArray = ByteStreamsKt.readBytes((InputStream)object);
        object = byArray;
        if (byArray == null) return null;
        ClassReader classReader = UtilityKt.asClassReader((byte[])object);
        object = classReader;
        if (classReader == null) return null;
        ClassNode classNode = UtilityKt.asClassNode((ClassReader)object);
        return classNode;
    }

    private final boolean isInterface(ClassNode $this$isInterface) {
        return ($this$isInterface.access & 0x200) != 0;
    }

    @Override
    @NotNull
    protected String getCommonSuperClass(@NotNull String type1, @NotNull String type2) {
        String string;
        Intrinsics.checkNotNullParameter(type1, "type1");
        Intrinsics.checkNotNullParameter(type2, "type2");
        if (!this.useBytecodeInheritance) {
            String string2 = super.getCommonSuperClass(type1, type2);
            Intrinsics.checkNotNullExpressionValue(string2, "getCommonSuperClass(...)");
            return string2;
        }
        if (Intrinsics.areEqual(type1, "java/lang/Object") || Intrinsics.areEqual(type2, "java/lang/Object")) {
            string = "java/lang/Object";
        } else if (Intrinsics.areEqual(type1, type2)) {
            string = type1;
        } else {
            ClassNode classNode = this.load(type1);
            if (classNode == null) {
                String string3 = super.getCommonSuperClass(type1, type2);
                Intrinsics.checkNotNullExpressionValue(string3, "getCommonSuperClass(...)");
                return string3;
            }
            ClassNode node1 = classNode;
            ClassNode classNode2 = this.load(type2);
            if (classNode2 == null) {
                String string4 = super.getCommonSuperClass(type1, type2);
                Intrinsics.checkNotNullExpressionValue(string4, "getCommonSuperClass(...)");
                return string4;
            }
            ClassNode node2 = classNode2;
            if (this.isInterface(node1) || this.isInterface(node2)) {
                string = "java/lang/Object";
            } else {
                string = (String)CollectionsKt.firstOrNull(CollectionsKt.intersect((Iterable)this.getAllParents(node1), CollectionsKt.toSet((Iterable)this.getAllParents(node2))));
                if (string == null) {
                    String string5 = super.getCommonSuperClass(type1, type2);
                    Intrinsics.checkNotNullExpressionValue(string5, "getCommonSuperClass(...)");
                    return string5;
                }
            }
        }
        return string;
    }

    private final List<String> getAllParents(ClassNode $this$getAllParents) {
        return CollectionsKt.plus((Collection)CollectionsKt.listOf($this$getAllParents.name), (Iterable)this.getParents($this$getAllParents));
    }

    private final List<String> getParents(ClassNode $this$getParents) {
        List<String> list;
        if (Intrinsics.areEqual($this$getParents.name, "java/lang/Object")) {
            list = CollectionsKt.emptyList();
        } else {
            Collection collection = CollectionsKt.listOf($this$getParents.superName);
            String string = $this$getParents.superName;
            Intrinsics.checkNotNullExpressionValue(string, "superName");
            Object object = this.load(string);
            list = CollectionsKt.plus(collection, object != null && (object = this.getParents((ClassNode)object)) != null ? (Iterable)object : (Iterable)CollectionsKt.emptyList());
        }
        return list;
    }
}

