/*
 * Decompiled with CFR 0.152.
 */
package net.weavemc.loader.bootstrap.transformer;

import java.io.InputStream;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.invoke.WrongMethodTypeException;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Collection;
import java.util.List;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.ByteStreamsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import net.weavemc.internals.InsnBuilder;
import net.weavemc.internals.InsnDslKt;
import net.weavemc.loader.mixin.LoaderClassWriter;
import net.weavemc.loader.util.UtilityKt;
import net.weavemc.relocate.asm.ClassReader;
import net.weavemc.relocate.asm.Type;
import net.weavemc.relocate.asm.tree.ClassNode;
import net.weavemc.relocate.asm.tree.LabelNode;
import net.weavemc.relocate.asm.tree.MethodNode;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u000eB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0004J#\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00062\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00060\fH\u0007\u00a2\u0006\u0002\u0010\r\u00a8\u0006\u000f"}, d2={"Lnet/weavemc/loader/bootstrap/transformer/ApplicationWrapper;", "", "()V", "insertWrapper", "", "className", "", "originalClass", "wrap", "", "targetMain", "args", "", "(Ljava/lang/String;[Ljava/lang/String;)V", "WrappingLoader", "loader"})
@SourceDebugExtension(value={"SMAP\nApplicationWrapper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ApplicationWrapper.kt\nnet/weavemc/loader/bootstrap/transformer/ApplicationWrapper\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,114:1\n1#2:115\n*E\n"})
public final class ApplicationWrapper {
    @NotNull
    public static final ApplicationWrapper INSTANCE = new ApplicationWrapper();

    private ApplicationWrapper() {
    }

    @NotNull
    public final byte[] insertWrapper(@NotNull String className, @NotNull byte[] originalClass) {
        LoaderClassWriter loaderClassWriter;
        Object v1;
        ClassNode node2;
        ClassReader reader;
        block2: {
            Intrinsics.checkNotNullParameter(className, "className");
            Intrinsics.checkNotNullParameter(originalClass, "originalClass");
            reader = UtilityKt.asClassReader(originalClass);
            node2 = UtilityKt.asClassNode(reader);
            List<MethodNode> list = node2.methods;
            Intrinsics.checkNotNullExpressionValue(list, "methods");
            Iterable iterable = list;
            for (Object t : iterable) {
                MethodNode it = (MethodNode)t;
                boolean bl = false;
                if (!Intrinsics.areEqual(it.name, "main")) continue;
                v1 = t;
                break block2;
            }
            v1 = null;
        }
        MethodNode methodNode = v1;
        if (methodNode == null) {
            UtilityKt.fatalError("Failed to find the main method in " + className + " whilst inserting wrapper");
            throw new KotlinNothingValueException();
        }
        MethodNode methodNode2 = methodNode;
        methodNode2.instructions.insert(InsnDslKt.asm((Function1<? super InsnBuilder, Unit>)new Function1<InsnBuilder, Unit>(node2, className){
            final /* synthetic */ ClassNode $node;
            final /* synthetic */ String $className;
            {
                this.$node = $node;
                this.$className = $className;
                super(1);
            }

            public final void invoke(@NotNull InsnBuilder $this$asm) {
                Intrinsics.checkNotNullParameter($this$asm, "$this$asm");
                Type type = Type.getObjectType(this.$node.name);
                Intrinsics.checkNotNullExpressionValue(type, "getObjectType(...)");
                $this$asm.ldc(type);
                $this$asm.invokevirtual("java/lang/Class", "getClassLoader", "()Ljava/lang/ClassLoader;");
                $this$asm.invokestatic("java/lang/ClassLoader", "getSystemClassLoader", "()Ljava/lang/ClassLoader;");
                LabelNode label = new LabelNode();
                $this$asm.if_acmpne(label);
                String string = this.$node.name;
                Intrinsics.checkNotNullExpressionValue(string, "name");
                $this$asm.ldc(StringsKt.replace$default(string, '/', '.', false, 4, null));
                $this$asm.aload(0);
                $this$asm.invokestatic("net/weavemc/loader/bootstrap/transformer/ApplicationWrapper", "wrap", "(Ljava/lang/String;[Ljava/lang/String;)V");
                $this$asm._return();
                $this$asm.unaryPlus(label);
                $this$asm.ldc(this.$className);
                Type type2 = Type.getObjectType(this.$className);
                Intrinsics.checkNotNullExpressionValue(type2, "getObjectType(...)");
                $this$asm.ldc(type2);
                $this$asm.invokevirtual("java/lang/Class", "getClassLoader", "()Ljava/lang/ClassLoader;");
                $this$asm.aload(0);
                $this$asm.invokestatic("net/weavemc/loader/bootstrap/BootstrapContainer", "finishBootstrap", "(Ljava/lang/String;Ljava/lang/ClassLoader;[Ljava/lang/String;)V");
            }
        }));
        ClassLoader classLoader = ClassLoader.getSystemClassLoader();
        Intrinsics.checkNotNullExpressionValue(classLoader, "getSystemClassLoader(...)");
        LoaderClassWriter it = loaderClassWriter = new LoaderClassWriter(classLoader, reader, 2, false, 8, null);
        boolean bl = false;
        node2.accept(it);
        byte[] byArray = loaderClassWriter.toByteArray();
        Intrinsics.checkNotNullExpressionValue(byArray, "toByteArray(...)");
        return byArray;
    }

    @JvmStatic
    public static final void wrap(@NotNull String targetMain, @NotNull String[] args2) {
        Intrinsics.checkNotNullParameter(targetMain, "targetMain");
        Intrinsics.checkNotNullParameter(args2, "args");
        System.out.println((Object)"[Weave] Minecraft Main was directly invoked, which potentially blocks transformation");
        String string = "[Weave] This is normal to happen on Vanilla Minecraft pre-launchwrapper. Therefore, the game will be wrapped into a new ClassLoader";
        System.out.println((Object)string);
        Class<?> mainClass = new WrappingLoader().loadClass(targetMain);
        try {
            MethodType type = MethodType.methodType(Void.TYPE, args2.getClass());
            MethodHandles.lookup().findStatic(mainClass, "main", type).invokeExact(args2);
        }
        catch (Throwable e) {
            Throwable throwable = e;
            if (((throwable instanceof WrongMethodTypeException ? true : throwable instanceof NoSuchMethodException) ? true : throwable instanceof IllegalAccessException) ? true : throwable instanceof ClassNotFoundException) {
                e.printStackTrace();
                System.out.println((Object)"[Weave] Failed to wrap game using java.lang.invoke, using Reflection fallback");
                Object[] objectArray = new Class[]{args2.getClass()};
                Method method = mainClass.getMethod("main", (Class<?>[])objectArray);
                objectArray = new Object[]{args2};
                method.invoke(null, objectArray);
            }
            throw e;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0014\u0010\u0003\u001a\u0006\u0012\u0002\b\u00030\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0014J\u001c\u0010\u0007\u001a\u0006\u0012\u0002\b\u00030\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\tH\u0014\u00a8\u0006\n"}, d2={"Lnet/weavemc/loader/bootstrap/transformer/ApplicationWrapper$WrappingLoader;", "Ljava/net/URLClassLoader;", "()V", "findClass", "Ljava/lang/Class;", "name", "", "loadClass", "resolve", "", "loader"})
    @SourceDebugExtension(value={"SMAP\nApplicationWrapper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ApplicationWrapper.kt\nnet/weavemc/loader/bootstrap/transformer/ApplicationWrapper$WrappingLoader\n+ 2 ArrayIntrinsics.kt\nkotlin/ArrayIntrinsicsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,114:1\n26#2:115\n1#3:116\n1747#4,3:117\n*S KotlinDebug\n*F\n+ 1 ApplicationWrapper.kt\nnet/weavemc/loader/bootstrap/transformer/ApplicationWrapper$WrappingLoader\n*L\n94#1:115\n103#1:117,3\n*E\n"})
    public static final class WrappingLoader
    extends URLClassLoader {
        public WrappingLoader() {
            boolean $i$f$emptyArray = false;
            super(new URL[0], URLClassLoader.getSystemClassLoader());
        }

        @Override
        @NotNull
        protected Class<?> loadClass(@NotNull String name, boolean resolve) {
            Class<?> clazz;
            Intrinsics.checkNotNullParameter(name, "name");
            Class<?> it = clazz = this.findClass(name);
            boolean bl = false;
            if (resolve) {
                this.resolveClass(it);
            }
            return clazz;
        }

        @Override
        @NotNull
        protected Class<?> findClass(@NotNull String name) {
            Object object;
            block12: {
                block11: {
                    boolean bl;
                    block10: {
                        Intrinsics.checkNotNullParameter(name, "name");
                        if (Intrinsics.areEqual(name, this.getClass().getName())) {
                            return this.getClass();
                        }
                        Class<?> clazz = this.findLoadedClass(name);
                        if (clazz != null) {
                            Class<?> it = clazz;
                            boolean bl2 = false;
                            return it;
                        }
                        Iterable $this$any$iv = UtilityKt.getIllegalToReload();
                        boolean $i$f$any = false;
                        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                            bl = false;
                        } else {
                            for (Object element$iv : $this$any$iv) {
                                String it = (String)element$iv;
                                boolean bl3 = false;
                                if (!StringsKt.startsWith$default(name, it, false, 2, null)) continue;
                                bl = true;
                                break block10;
                            }
                            bl = false;
                        }
                    }
                    if (bl || Intrinsics.areEqual(name, "net.weavemc.loader.bootstrap.BootstrapContainer")) {
                        Class<?> clazz = this.getParent().loadClass(name);
                        Intrinsics.checkNotNullExpressionValue(clazz, "loadClass(...)");
                        return clazz;
                    }
                    String internalName = StringsKt.replace$default(name, '.', '/', false, 4, null);
                    object = this.getResourceAsStream(internalName + ".class");
                    if (object == null) break block11;
                    byte[] byArray = ByteStreamsKt.readBytes((InputStream)object);
                    object = byArray;
                    if (byArray != null) break block12;
                }
                throw new ClassNotFoundException();
            }
            Object bytes = object;
            Class<?> clazz = this.defineClass(name, (byte[])bytes, 0, ((Object)bytes).length);
            Intrinsics.checkNotNullExpressionValue(clazz, "defineClass(...)");
            return clazz;
        }
    }
}

