/*
 * Decompiled with CFR 0.152.
 */
package net.weavemc.loader.bootstrap;

import java.lang.instrument.Instrumentation;
import java.lang.reflect.Constructor;
import java.net.URL;
import java.security.ProtectionDomain;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import net.weavemc.internals.GameInfo;
import net.weavemc.loader.bootstrap.Bootstrap;
import net.weavemc.loader.bootstrap.transformer.ApplicationWrapper;
import net.weavemc.loader.bootstrap.transformer.SafeTransformer;
import net.weavemc.loader.bootstrap.transformer.URLClassLoaderAccessor;
import net.weavemc.loader.bootstrap.transformer.URLClassLoaderTransformer;
import net.weavemc.loader.util.UtilityKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u0012\u0010\u0007\u001a\u00020\u00042\b\u0010\b\u001a\u0004\u0018\u00010\tH\u0002\u00a8\u0006\b"}, d2={"Lnet/weavemc/loader/bootstrap/Bootstrap;", "", "()V", "bootstrap", "", "inst", "Ljava/lang/instrument/Instrumentation;", "printBootstrap", "loader", "Ljava/lang/ClassLoader;"})
public final class Bootstrap {
    @NotNull
    public static final Bootstrap INSTANCE = new Bootstrap();

    private Bootstrap() {
    }

    public final void bootstrap(@NotNull Instrumentation inst) {
        Intrinsics.checkNotNullParameter(inst, "inst");
        inst.addTransformer(new SafeTransformer(inst){
            final /* synthetic */ Instrumentation $inst;
            {
                this.$inst = $inst;
            }

            @Nullable
            public byte[] transform(@Nullable ClassLoader loader, @NotNull String className, @NotNull byte[] originalClass) {
                Intrinsics.checkNotNullParameter(className, "className");
                Intrinsics.checkNotNullParameter(originalClass, "originalClass");
                if (Intrinsics.areEqual(className, "net/minecraft/client/main/Main")) {
                    Object[] objectArray;
                    if (Intrinsics.areEqual(loader, ClassLoader.getSystemClassLoader())) {
                        return ApplicationWrapper.INSTANCE.insertWrapper(className, originalClass);
                    }
                    Bootstrap.access$printBootstrap(Bootstrap.INSTANCE, loader);
                    this.$inst.removeTransformer(this);
                    this.$inst.removeTransformer(URLClassLoaderTransformer.INSTANCE);
                    if (!(loader instanceof URLClassLoaderAccessor)) {
                        UtilityKt.fatalError("Failed to transform URLClassLoader to implement URLClassLoaderAccessor. Impossible to recover");
                        throw new KotlinNothingValueException();
                    }
                    ClassLoader clAccessor = loader;
                    Object object = this;
                    try {
                        bootstrap.1 $this$transform_u24lambda_u240 = object;
                        boolean bl = false;
                        URLClassLoaderAccessor uRLClassLoaderAccessor = (URLClassLoaderAccessor)((Object)clAccessor);
                        URL uRL = $this$transform_u24lambda_u240.getClass().getProtectionDomain().getCodeSource().getLocation();
                        Intrinsics.checkNotNullExpressionValue(uRL, "getLocation(...)");
                        uRLClassLoaderAccessor.addWeaveURL(uRL);
                        objectArray = Result.constructor-impl(Unit.INSTANCE);
                    }
                    catch (Throwable bl) {
                        objectArray = Result.constructor-impl(ResultKt.createFailure(bl));
                    }
                    object = objectArray;
                    Throwable throwable = Result.exceptionOrNull-impl(object);
                    if (throwable != null) {
                        objectArray = throwable;
                        Class[] it = objectArray;
                        boolean bl = false;
                        it.printStackTrace();
                        UtilityKt.fatalError("Failed to deliberately add Weave to the target classloader");
                        throw new KotlinNothingValueException();
                    }
                    System.out.println((Object)"[Weave] Bootstrapping complete.");
                    Class<?> wlc = loader.loadClass("net.weavemc.loader.WeaveLoader");
                    objectArray = new Class[]{URLClassLoaderAccessor.class, Instrumentation.class};
                    Constructor<?> constructor = wlc.getConstructor((Class<?>[])objectArray);
                    objectArray = new Object[]{clAccessor, this.$inst};
                    constructor.newInstance(objectArray);
                }
                return null;
            }

            @Nullable
            public byte[] transform(@Nullable ClassLoader loader, @NotNull String className, @Nullable Class<?> classBeingRedefined, @Nullable ProtectionDomain protectionDomain, @NotNull byte[] classfileBuffer) {
                return SafeTransformer.DefaultImpls.transform(this, loader, className, classBeingRedefined, protectionDomain, classfileBuffer);
            }
        });
    }

    private final void printBootstrap(ClassLoader loader) {
        String string = StringsKt.trimIndent("\n            [Weave] Bootstrapping...\n                - Version: " + GameInfo.INSTANCE.getVersion().getVersionName() + "\n                - Client: " + GameInfo.INSTANCE.getClient().getClientName() + "\n                - Loader: " + loader + "\n            ");
        System.out.println((Object)string);
    }

    public static final /* synthetic */ void access$printBootstrap(Bootstrap $this, ClassLoader loader) {
        $this.printBootstrap(loader);
    }
}

