/*
 * Decompiled with CFR 0.152.
 */
package net.weavemc.loader;

import com.grappenmaker.mappings.ClasspathLoaders;
import com.grappenmaker.mappings.ClasspathLoadersKt;
import com.grappenmaker.mappings.MappingsRemapper;
import java.io.Closeable;
import java.io.File;
import java.lang.instrument.Instrumentation;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.jar.JarFile;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.Grouping;
import kotlin.collections.GroupingKt;
import kotlin.collections.MapsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import net.weavemc.api.Hook;
import net.weavemc.api.ModInitializer;
import net.weavemc.internals.GameInfo;
import net.weavemc.internals.MinecraftVersion;
import net.weavemc.internals.ModConfig;
import net.weavemc.loader.InjectionHandler;
import net.weavemc.loader.ModHook;
import net.weavemc.loader.Modifier;
import net.weavemc.loader.WeaveLoader;
import net.weavemc.loader.bootstrap.transformer.URLClassLoaderAccessor;
import net.weavemc.loader.mixin.SandboxedMixinLoader;
import net.weavemc.loader.mixin.SandboxedMixinState;
import net.weavemc.loader.util.AnalyticsKt;
import net.weavemc.loader.util.FileManager;
import net.weavemc.loader.util.MappingsHandler;
import net.weavemc.loader.util.UtilityKt;
import net.weavemc.loader.util.WeaveMod;
import net.weavemc.relocate.asm.tree.ClassNode;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u001d2\u00020\u0001:\u0001\u001dB\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u0010\u001a\u00020\u0011H\u0002J\u0006\u0010\u0012\u001a\u00020\u0011J\u0010\u0010\u0013\u001a\u00020\n2\u0006\u0010\u0014\u001a\u00020\tH\u0002J\b\u0010\u0015\u001a\u00020\u0011H\u0002J\u000e\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u0017H\u0002J\b\u0010\u0019\u001a\u00020\u0011H\u0002J\f\u0010\u001a\u001a\u00020\u0018*\u00020\u001bH\u0002J\f\u0010\u001c\u001a\u00020\u0011*\u00020\u0018H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u001e"}, d2={"Lnet/weavemc/loader/WeaveLoader;", "", "classLoader", "Lnet/weavemc/loader/bootstrap/transformer/URLClassLoaderAccessor;", "instrumentation", "Ljava/lang/instrument/Instrumentation;", "(Lnet/weavemc/loader/bootstrap/transformer/URLClassLoaderAccessor;Ljava/lang/instrument/Instrumentation;)V", "mixinInstances", "", "", "Lnet/weavemc/loader/mixin/SandboxedMixinLoader;", "mods", "", "Lnet/weavemc/loader/util/WeaveMod;", "getMods", "()Ljava/util/List;", "finalize", "", "initializeMods", "mixinForNamespace", "namespace", "populateMixinModifiers", "retrieveMods", "", "Ljava/io/File;", "verifyDependencies", "parseAndMap", "Lnet/weavemc/loader/util/FileManager$ModJar;", "registerAsMod", "Companion", "loader"})
@SourceDebugExtension(value={"SMAP\nWeaveLoader.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WeaveLoader.kt\nnet/weavemc/loader/WeaveLoader\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Utility.kt\nnet/weavemc/loader/util/UtilityKt\n+ 4 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 5 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,188:1\n1855#2,2:189\n1855#2:191\n1855#2:192\n1856#2:197\n1856#2:198\n1855#2:199\n1855#2:200\n1856#2:205\n1856#2:206\n1536#2:207\n1179#2,2:215\n1253#2,4:217\n1855#2,2:221\n1855#2:231\n1856#2:236\n1855#2,2:237\n1549#2:239\n1620#2,3:240\n1855#2,2:243\n127#3,4:193\n127#3,4:201\n127#3,4:232\n494#4,7:208\n372#4,3:223\n375#4,4:227\n1#5:226\n*S KotlinDebug\n*F\n+ 1 WeaveLoader.kt\nnet/weavemc/loader/WeaveLoader\n*L\n56#1:189,2\n62#1:191\n63#1:192\n63#1:197\n62#1:198\n77#1:199\n78#1:200\n78#1:205\n77#1:206\n85#1:207\n88#1:215,2\n88#1:217,4\n90#1:221,2\n149#1:231\n149#1:236\n155#1:237,2\n187#1:239\n187#1:240,3\n101#1:243,2\n64#1:193,4\n79#1:201,4\n151#1:232,4\n85#1:208,7\n108#1:223,3\n108#1:227,4\n*E\n"})
public final class WeaveLoader {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final URLClassLoaderAccessor classLoader;
    @NotNull
    private final Instrumentation instrumentation;
    @NotNull
    private final List<WeaveMod> mods;
    @NotNull
    private final Map<String, SandboxedMixinLoader> mixinInstances;
    @Nullable
    private static WeaveLoader INSTANCE;

    public WeaveLoader(@NotNull URLClassLoaderAccessor classLoader, @NotNull Instrumentation instrumentation) {
        Intrinsics.checkNotNullParameter(classLoader, "classLoader");
        Intrinsics.checkNotNullParameter(instrumentation, "instrumentation");
        this.classLoader = classLoader;
        this.instrumentation = instrumentation;
        this.mods = new ArrayList();
        this.mixinInstances = new LinkedHashMap();
        System.out.println((Object)"[Weave] Initializing Weave");
        INSTANCE = this;
        AnalyticsKt.setLaunchStart(System.currentTimeMillis());
        this.instrumentation.addTransformer(InjectionHandler.INSTANCE);
        this.finalize();
    }

    @NotNull
    public final List<WeaveMod> getMods() {
        return this.mods;
    }

    private final void finalize() {
        Iterable $this$forEach$iv = this.retrieveMods();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            File it = (File)element$iv;
            boolean bl = false;
            this.registerAsMod(it);
        }
        this.verifyDependencies();
        this.populateMixinModifiers();
        $this$forEach$iv = this.mods;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            WeaveMod weaveMod = (WeaveMod)element$iv;
            boolean bl = false;
            Iterable $this$forEach$iv2 = weaveMod.getConfig().getEntryPoints();
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                String entrypoint = (String)element$iv2;
                boolean bl2 = false;
                boolean $i$f$instantiate = false;
                Object obj = Class.forName(entrypoint).getConstructor(new Class[0]).newInstance(new Object[0]);
                if (!(obj instanceof ModInitializer)) {
                    obj = null;
                }
                ModInitializer modInitializer = (ModInitializer)obj;
                if (modInitializer == null) {
                    throw new IllegalStateException((entrypoint + " does not implement " + ModInitializer.class.getSimpleName() + '!').toString());
                }
                modInitializer.preInit(this.instrumentation);
            }
        }
        System.out.println((Object)"[Weave] Initialized Weave");
        AnalyticsKt.updateLaunchTimes();
    }

    public final void initializeMods() {
        Iterable $this$forEach$iv = this.mods;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            WeaveMod weaveMod = (WeaveMod)element$iv;
            boolean bl = false;
            Iterable $this$forEach$iv2 = weaveMod.getConfig().getEntryPoints();
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                String entrypoint = (String)element$iv2;
                boolean bl2 = false;
                boolean $i$f$instantiate = false;
                Object obj = Class.forName(entrypoint).getConstructor(new Class[0]).newInstance(new Object[0]);
                if (!(obj instanceof ModInitializer)) {
                    obj = null;
                }
                ModInitializer modInitializer = (ModInitializer)obj;
                if (modInitializer == null) {
                    throw new IllegalStateException((entrypoint + " does not implement " + ModInitializer.class.getSimpleName() + '!').toString());
                }
                modInitializer.init();
            }
        }
    }

    private final void verifyDependencies() {
        Iterable $this$groupingBy$iv = this.mods;
        boolean $i$f$groupingBy = false;
        Map $this$filterValues$iv = GroupingKt.eachCount((Grouping)new Grouping<WeaveMod, String>($this$groupingBy$iv){
            final /* synthetic */ Iterable $this_groupingBy;
            {
                this.$this_groupingBy = $receiver;
            }

            @NotNull
            public Iterator<WeaveMod> sourceIterator() {
                return this.$this_groupingBy.iterator();
            }

            /*
             * Ignored method signature, as it can't be verified against descriptor
             */
            public Object keyOf(Object element) {
                WeaveMod it = (WeaveMod)element;
                boolean bl = false;
                return it.getModId();
            }
        });
        boolean $i$f$filterValues = false;
        LinkedHashMap result$iv = new LinkedHashMap();
        for (Map.Entry entry : $this$filterValues$iv.entrySet()) {
            int it = ((Number)entry.getValue()).intValue();
            boolean bl = false;
            if (!(it > 1)) continue;
            result$iv.put(entry.getKey(), entry.getValue());
        }
        Set duplicates = ((Map)result$iv).keySet();
        if (!((Collection)duplicates).isEmpty()) {
            UtilityKt.fatalError("Duplicate mods " + CollectionsKt.joinToString$default(duplicates, null, null, null, 0, null, null, 63, null) + " were found");
            throw new KotlinNothingValueException();
        }
        Iterable $this$associate$iv = this.mods;
        boolean $i$f$associate = false;
        int capacity$iv = RangesKt.coerceAtLeast(MapsKt.mapCapacity(CollectionsKt.collectionSizeOrDefault($this$associate$iv, 10)), 16);
        Iterable iterable = $this$associate$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateTo = false;
        for (Object element$iv$iv : iterable) {
            Map map = destination$iv$iv;
            WeaveMod it = (WeaveMod)element$iv$iv;
            boolean bl = false;
            Pair<String, List<String>> pair = TuplesKt.to(it.getModId(), it.getConfig().getDependencies());
            map.put(pair.getFirst(), pair.getSecond());
        }
        Map dependencyGraph = destination$iv$iv;
        HashSet<String> seen = new HashSet<String>();
        Iterable $this$forEach$iv = dependencyGraph.keySet();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String toDetermine = (String)element$iv;
            boolean bl = false;
            WeaveLoader.verifyDependencies$lambda$9$verify(toDetermine, seen, dependencyGraph, toDetermine, CollectionsKt.emptyList());
        }
    }

    private final SandboxedMixinLoader mixinForNamespace(String namespace) {
        SandboxedMixinLoader sandboxedMixinLoader;
        Map<String, SandboxedMixinLoader> $this$getOrPut$iv = this.mixinInstances;
        boolean $i$f$getOrPut = false;
        SandboxedMixinLoader value$iv = $this$getOrPut$iv.get(namespace);
        if (value$iv == null) {
            SandboxedMixinLoader sandboxedMixinLoader2;
            boolean bl = false;
            ClassLoader parent = this.classLoader.getBacking();
            SandboxedMixinLoader $this$mixinForNamespace_u24lambda_u2411_u24lambda_u2410 = sandboxedMixinLoader2 = new SandboxedMixinLoader(parent, ClasspathLoadersKt.remappingNames(ClasspathLoaders.INSTANCE.fromLoader(parent), MappingsHandler.INSTANCE.getMergedMappings().getMappings(), "official", namespace));
            boolean bl2 = false;
            $this$mixinForNamespace_u24lambda_u2411_u24lambda_u2410.getState().initialize();
            SandboxedMixinLoader answer$iv = sandboxedMixinLoader2;
            $this$getOrPut$iv.put(namespace, answer$iv);
            sandboxedMixinLoader = answer$iv;
        } else {
            sandboxedMixinLoader = value$iv;
        }
        return sandboxedMixinLoader;
    }

    private final void populateMixinModifiers() {
        for (String ns : MappingsHandler.INSTANCE.getMergedMappings().getMappings().getNamespaces()) {
            SandboxedMixinState state = this.mixinForNamespace(ns).getState();
            Set<String> targets = state.findTargets(state.getTransformer$loader());
            if (targets.isEmpty()) continue;
            MappingsRemapper mapper = MappingsHandler.INSTANCE.mapper(ns, MappingsHandler.INSTANCE.getEnvironmentNamespace());
            InjectionHandler.INSTANCE.registerModifier(new Modifier(ns, targets, mapper, state){
                @NotNull
                private final String namespace;
                @NotNull
                private final HashSet<String> targets;
                final /* synthetic */ SandboxedMixinState $state;
                {
                    void destination$iv;
                    void $this$mapTo$iv;
                    this.$state = $state;
                    this.namespace = $ns;
                    Iterable iterable = $targets;
                    Collection collection = new HashSet<E>();
                    populateMixinModifiers.1 var12_7 = this;
                    boolean $i$f$mapTo = false;
                    for (T item$iv : $this$mapTo$iv) {
                        void it;
                        String string = (String)item$iv;
                        void var13_13 = destination$iv;
                        boolean bl = false;
                        var13_13.add($mapper.map(StringsKt.replace$default((String)it, '.', '/', false, 4, null)));
                    }
                    var12_7.targets = (HashSet)destination$iv;
                }

                @NotNull
                public String getNamespace() {
                    return this.namespace;
                }

                @NotNull
                public HashSet<String> getTargets() {
                    return this.targets;
                }

                @NotNull
                public ClassNode apply(@NotNull ClassNode node2, @NotNull Hook.AssemblerConfig cfg) {
                    Intrinsics.checkNotNullParameter(node2, "node");
                    Intrinsics.checkNotNullParameter(cfg, "cfg");
                    cfg.computeFrames();
                    String string = node2.name;
                    Intrinsics.checkNotNullExpressionValue(string, "name");
                    return this.$state.transform(string, node2);
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void registerAsMod(File $this$registerAsMod) {
        System.out.println((Object)("[Weave] Registering " + $this$registerAsMod.getName()));
        URL uRL = $this$registerAsMod.toURI().toURL();
        Intrinsics.checkNotNullExpressionValue(uRL, "toURL(...)");
        this.classLoader.addWeaveURL(uRL);
        Closeable closeable = new JarFile($this$registerAsMod);
        Throwable throwable = null;
        try {
            JarFile jar = (JarFile)closeable;
            boolean bl = false;
            ModConfig config = UtilityKt.configOrFatal(jar);
            String modId = config.getModId();
            this.instrumentation.appendToSystemClassLoaderSearch(jar);
            Iterable $this$forEach$iv = config.getHooks();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                String hook = (String)element$iv;
                boolean bl2 = false;
                System.out.println((Object)("[Weave] Registering hook " + hook));
                String string = config.getNamespace();
                boolean $i$f$instantiate = false;
                Object obj = Class.forName(hook).getConstructor(new Class[0]).newInstance(new Object[0]);
                if (!(obj instanceof Hook)) {
                    obj = null;
                }
                Hook hook2 = (Hook)obj;
                if (hook2 == null) {
                    throw new IllegalStateException((hook + " does not implement " + Hook.class.getSimpleName() + '!').toString());
                }
                InjectionHandler.INSTANCE.registerModifier(new ModHook(string, hook2, null, 4, null));
            }
            SandboxedMixinState state = this.mixinForNamespace(config.getNamespace()).getState();
            Iterable $this$forEach$iv2 = config.getMixinConfigs();
            boolean $i$f$forEach2 = false;
            for (Object element$iv : $this$forEach$iv2) {
                String it = (String)element$iv;
                boolean bl3 = false;
                state.registerMixin(modId, it);
            }
            ((Collection)this.mods).add(new WeaveMod(modId, config));
            System.out.println((Object)("[Weave] Registered " + $this$registerAsMod.getName()));
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally(closeable, throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final File parseAndMap(FileManager.ModJar $this$parseAndMap) {
        File file;
        String string = $this$parseAndMap.getFile().getName();
        Intrinsics.checkNotNullExpressionValue(string, "getName(...)");
        String fileName = StringsKt.substringBeforeLast$default(string, '.', null, 2, null);
        Closeable closeable = new JarFile($this$parseAndMap.getFile());
        Throwable throwable = null;
        try {
            JarFile it = (JarFile)closeable;
            boolean bl = false;
            ModConfig config = UtilityKt.configOrFatal(it);
            String compiledFor = config.getCompiledFor();
            if (compiledFor != null && GameInfo.INSTANCE.getVersion() != MinecraftVersion.Companion.fromVersionName(compiledFor)) {
                String extra = !$this$parseAndMap.isSpecific() ? " Hint: this mod was placed in the general mods folder. Consider putting mods in a version-specific mods folder" : "";
                UtilityKt.fatalError("Mod " + config.getModId() + " was compiled for version " + compiledFor + ", current version is " + GameInfo.INSTANCE.getVersion().getVersionName() + '.' + extra);
                throw new KotlinNothingValueException();
            }
            if (!MappingsHandler.INSTANCE.isNamespaceAvailable(config.getNamespace())) {
                UtilityKt.fatalError("Mod " + config.getModId() + " was mapped in namespace " + config.getNamespace() + ", which is not available!");
                throw new KotlinNothingValueException();
            }
            file = UtilityKt.createRemappedTemp($this$parseAndMap.getFile(), fileName, config);
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally(closeable, throwable);
        }
        return file;
    }

    /*
     * WARNING - void declaration
     */
    private final List<File> retrieveMods() {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = FileManager.INSTANCE.getMods();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            FileManager.ModJar modJar = (FileManager.ModJar)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(this.parseAndMap((FileManager.ModJar)it));
        }
        return (List)destination$iv$iv;
    }

    private static final void verifyDependencies$lambda$9$verify(String $toDetermine, HashSet<String> seen, Map<String, ? extends List<String>> dependencyGraph, String curr, List<String> soFar) {
        if (soFar.contains(curr)) {
            UtilityKt.fatalError("Circular dependency: " + $toDetermine + "'s dependency graph eventually meets " + curr + " again through " + CollectionsKt.joinToString$default(CollectionsKt.plus((Collection)soFar, curr), " -> ", null, null, 0, null, null, 62, null));
            throw new KotlinNothingValueException();
        }
        if (!seen.add(curr)) {
            return;
        }
        List<String> list = dependencyGraph.get(curr);
        if (list == null) {
            UtilityKt.fatalError("Dependency " + curr + " for mod " + $toDetermine + " is not available");
            throw new KotlinNothingValueException();
        }
        List<String> deps = list;
        Iterable $this$forEach$iv = deps;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String it = (String)element$iv;
            boolean bl = false;
            WeaveLoader.verifyDependencies$lambda$9$verify($toDetermine, seen, dependencyGraph, it, CollectionsKt.plus((Collection)soFar, curr));
        }
    }

    @JvmStatic
    @NotNull
    public static final WeaveLoader getInstance() {
        return Companion.getInstance();
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0005\u001a\u00020\u0004H\u0007R\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lnet/weavemc/loader/WeaveLoader$Companion;", "", "()V", "INSTANCE", "Lnet/weavemc/loader/WeaveLoader;", "getInstance", "loader"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final WeaveLoader getInstance() {
            WeaveLoader weaveLoader = INSTANCE;
            if (weaveLoader == null) {
                UtilityKt.fatalError("Attempted to retrieve WeaveLoader instance before it has been instantiated!");
                throw new KotlinNothingValueException();
            }
            return weaveLoader;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

