/*
 * Decompiled with CFR 0.152.
 */
package net.weavemc.loader;

import com.grappenmaker.mappings.LambdaAwareRemapper;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.UInt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.random.Random;
import kotlin.random.URandomKt;
import net.weavemc.internals.InsnDslKt;
import net.weavemc.loader.AssemblerConfigImpl;
import net.weavemc.loader.InjectionClassWriter;
import net.weavemc.loader.Modifier;
import net.weavemc.loader.bootstrap.transformer.SafeTransformer;
import net.weavemc.loader.util.FileManager;
import net.weavemc.loader.util.MappingsHandler;
import net.weavemc.loader.util.UtilityKt;
import net.weavemc.relocate.asm.ClassReader;
import net.weavemc.relocate.asm.commons.Remapper;
import net.weavemc.relocate.asm.commons.SimpleRemapper;
import net.weavemc.relocate.asm.tree.ClassNode;
import net.weavemc.relocate.asm.tree.MethodNode;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\tJ$\u0010\r\u001a\u0004\u0018\u00010\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u000eH\u0016J\u001c\u0010\u0014\u001a\u00020\u0015*\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00122\u0006\u0010\u0017\u001a\u00020\u0012H\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lnet/weavemc/loader/InjectionHandler;", "Lnet/weavemc/loader/bootstrap/transformer/SafeTransformer;", "()V", "dumpBytecode", "", "getDumpBytecode", "()Z", "modifiers", "", "Lnet/weavemc/loader/Modifier;", "registerModifier", "", "modifier", "transform", "", "loader", "Ljava/lang/ClassLoader;", "className", "", "originalClass", "remap", "Lorg/objectweb/asm/tree/ClassNode;", "from", "to"})
@SourceDebugExtension(value={"SMAP\nInjectionHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 InjectionHandler.kt\nnet/weavemc/loader/InjectionHandler\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 4 Utility.kt\nnet/weavemc/loader/util/UtilityKt\n+ 5 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,165:1\n766#2:166\n857#2,2:167\n1477#2:169\n1502#2,3:170\n1505#2,3:180\n766#2:183\n857#2,2:184\n1789#2,2:188\n1789#2,3:190\n1791#2:193\n372#3,7:173\n50#4:186\n1#5:187\n1#5:194\n*S KotlinDebug\n*F\n+ 1 InjectionHandler.kt\nnet/weavemc/loader/InjectionHandler\n*L\n41#1:166\n41#1:167,2\n41#1:169\n41#1:170,3\n41#1:180,3\n49#1:183\n49#1:184,2\n67#1:188,2\n70#1:190,3\n67#1:193\n41#1:173,7\n64#1:186\n64#1:187\n*E\n"})
public final class InjectionHandler
implements SafeTransformer {
    @NotNull
    public static final InjectionHandler INSTANCE = new InjectionHandler();
    private static final boolean dumpBytecode;
    @NotNull
    private static final List<Modifier> modifiers;

    private InjectionHandler() {
    }

    public final boolean getDumpBytecode() {
        return dumpBytecode;
    }

    public final void registerModifier(@NotNull Modifier modifier) {
        Intrinsics.checkNotNullParameter(modifier, "modifier");
        ((Collection)modifiers).add(modifier);
    }

    private final ClassNode remap(ClassNode $this$remap, String from, String to) {
        return Intrinsics.areEqual(from, to) ? $this$remap : MappingsHandler.remap$loader$default(MappingsHandler.INSTANCE, $this$remap, (Remapper)MappingsHandler.INSTANCE.mapper(from, to), 0, 2, null);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Nullable
    public byte[] transform(@Nullable ClassLoader loader, @NotNull String className, @NotNull byte[] originalClass) {
        InjectionClassWriter classWriter;
        block12: {
            Object object;
            void $this$pushToFirst$iv;
            String string2;
            MethodNode it;
            Iterator $this$filterTo$iv$iv;
            Iterable list$iv$iv;
            Object $this$getOrPut$iv$iv$iv;
            void $this$groupByTo$iv$iv;
            void $this$groupBy$iv;
            Modifier it2;
            void $this$filterTo$iv$iv2;
            Intrinsics.checkNotNullParameter(className, "className");
            Intrinsics.checkNotNullParameter(originalClass, "originalClass");
            Iterable $this$filter$iv = modifiers;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Iterator destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv2) {
                it2 = (Modifier)element$iv$iv;
                boolean bl = false;
                if (!it2.getTargets().contains(className)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filter$iv = (List)((Object)destination$iv$iv);
            boolean $i$f$groupBy = false;
            $this$filterTo$iv$iv2 = $this$groupBy$iv;
            destination$iv$iv = new LinkedHashMap();
            boolean $i$f$groupByTo = false;
            for (Object element$iv$iv : $this$groupByTo$iv$iv) {
                Object object2;
                it2 = (Modifier)element$iv$iv;
                boolean bl = false;
                String key$iv$iv = it2.getNamespace();
                $this$getOrPut$iv$iv$iv = destination$iv$iv;
                boolean $i$f$getOrPut = false;
                Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
                if (value$iv$iv$iv == null) {
                    boolean bl2 = false;
                    List answer$iv$iv$iv = new ArrayList();
                    $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                    object2 = answer$iv$iv$iv;
                } else {
                    object2 = value$iv$iv$iv;
                }
                list$iv$iv = (List)object2;
                list$iv$iv.add(element$iv$iv);
            }
            Iterator groupedModifiers = destination$iv$iv;
            if (groupedModifiers.isEmpty()) {
                return null;
            }
            MappingsHandler $this$transform_u24lambda_u248 = MappingsHandler.INSTANCE;
            boolean bl = false;
            ClassReader classReader = UtilityKt.asClassReader(originalClass);
            ClassNode originalNode = UtilityKt.asClassNode(classReader);
            List<MethodNode> list = originalNode.methods;
            Intrinsics.checkNotNullExpressionValue(list, "methods");
            Iterable $this$filter$iv2 = list;
            boolean $i$f$filter2 = false;
            list$iv$iv = $this$filter$iv2;
            Collection destination$iv$iv2 = new ArrayList();
            boolean $i$f$filterTo2 = false;
            $this$getOrPut$iv$iv$iv = $this$filterTo$iv$iv.iterator();
            while ($this$getOrPut$iv$iv$iv.hasNext()) {
                Object element$iv$iv = $this$getOrPut$iv$iv$iv.next();
                it = (MethodNode)element$iv$iv;
                boolean string2 = false;
                Intrinsics.checkNotNull(it);
                if (!UtilityKt.hasMixinAnnotation(it, "MixinMerged")) continue;
                destination$iv$iv2.add(element$iv$iv);
            }
            List potentialConflicts = (List)destination$iv$iv2;
            HashMap conflictsMapping = new HashMap();
            HashMap inverseConflictsMapping = new HashMap();
            for (MethodNode m : potentialConflicts) {
                String tempName = "potentialConflict" + UInt.toString-impl(URandomKt.nextUInt(Random.Default));
                ((Map)conflictsMapping).put(originalNode.name + '.' + m.name + m.desc, tempName);
                $this$getOrPut$iv$iv$iv = inverseConflictsMapping;
                String element$iv$iv = originalNode.name + '.' + tempName + m.desc;
                Intrinsics.checkNotNullExpressionValue(m.name, "name");
                $this$getOrPut$iv$iv$iv.put(element$iv$iv, it);
            }
            ClassNode classNode = new ClassNode();
            originalNode.accept(new LambdaAwareRemapper(classNode, new SimpleRemapper(conflictsMapping)));
            AssemblerConfigImpl hookConfig = new AssemblerConfigImpl();
            $this$getOrPut$iv$iv$iv = groupedModifiers.keySet();
            String element$iv = $this$transform_u24lambda_u248.getEnvironmentNamespace();
            boolean $i$f$pushToFirst = false;
            String it$iv = string2 = element$iv;
            boolean bl3 = false;
            List modifierNamespaces = CollectionsKt.plus((Collection)CollectionsKt.listOfNotNull($this$pushToFirst$iv.contains(it$iv) ? string2 : null), (Iterable)SetsKt.minus($this$pushToFirst$iv, element$iv));
            Pair<ClassNode, String> start = TuplesKt.to(classNode, $this$transform_u24lambda_u248.getEnvironmentNamespace());
            Iterable $this$fold$iv = modifierNamespaces;
            boolean $i$f$fold = false;
            Pair<ClassNode, Object> accumulator$iv = start;
            for (Object element$iv2 : $this$fold$iv) {
                void $this$fold$iv2;
                void currentNamespace;
                object = (String)element$iv2;
                Pair<ClassNode, String> pair = accumulator$iv;
                boolean bl4 = false;
                ClassNode modifiedNode = pair.component1();
                String lastNamespace = pair.component2();
                ClassNode mappedNode = INSTANCE.remap(modifiedNode, lastNamespace, (String)currentNamespace);
                Iterable iterable2 = (Iterable)MapsKt.getValue(groupedModifiers, currentNamespace);
                boolean $i$f$fold2 = false;
                ClassNode accumulator$iv2 = mappedNode;
                for (Object element$iv3 : $this$fold$iv2) {
                    void curr;
                    Modifier modifier = (Modifier)element$iv3;
                    ClassNode acc = accumulator$iv2;
                    boolean bl5 = false;
                    accumulator$iv2 = curr.apply(acc, hookConfig);
                }
                ClassNode nextNode = accumulator$iv2;
                accumulator$iv = TuplesKt.to(nextNode, currentNamespace);
            }
            Pair<ClassNode, String> pair = accumulator$iv;
            ClassNode finalNode = pair.component1();
            String lastNamespace = pair.component2();
            classWriter = new InjectionClassWriter(hookConfig.getClassWriterFlags(), classReader);
            INSTANCE.remap(finalNode, lastNamespace, $this$transform_u24lambda_u248.getEnvironmentNamespace()).accept(new LambdaAwareRemapper(classWriter, new SimpleRemapper(inverseConflictsMapping)));
            if (!dumpBytecode) break block12;
            Object object3 = FileManager.INSTANCE.getDUMP_DIRECTORY().resolve(className + ".class");
            Path it3 = object3;
            boolean bl6 = false;
            Path path = it3.getParent();
            Intrinsics.checkNotNullExpressionValue(path, "getParent(...)");
            Path bl4 = path;
            FileAttribute[] fileAttributeArray = new FileAttribute[]{};
            Intrinsics.checkNotNullExpressionValue(Files.createDirectories(bl4, Arrays.copyOf(fileAttributeArray, fileAttributeArray.length)), "createDirectories(...)");
            File bytecodeOut = object3.toFile();
            object3 = $this$transform_u24lambda_u248;
            try {
                Object $this$transform_u24lambda_u248_u24lambda_u246 = object3;
                boolean bl7 = false;
                byte[] byArray = classWriter.toByteArray();
                Intrinsics.checkNotNullExpressionValue(byArray, "toByteArray(...)");
                String string3 = bytecodeOut.getAbsolutePath();
                Intrinsics.checkNotNullExpressionValue(string3, "getAbsolutePath(...)");
                InsnDslKt.dump(byArray, string3);
                object = Result.constructor-impl(Unit.INSTANCE);
            }
            catch (Throwable bl7) {
                object = Result.constructor-impl(ResultKt.createFailure(bl7));
            }
            object3 = object;
            Throwable throwable = Result.exceptionOrNull-impl(object3);
            if (throwable != null) {
                Object it4 = object = throwable;
                boolean bl8 = false;
                System.out.println((Object)("Failed to dump bytecode for " + bytecodeOut));
            }
        }
        return classWriter.toByteArray();
    }

    @Override
    @Nullable
    public byte[] transform(@Nullable ClassLoader loader, @NotNull String className, @Nullable Class<?> classBeingRedefined, @Nullable ProtectionDomain protectionDomain, @NotNull byte[] classfileBuffer) {
        return SafeTransformer.DefaultImpls.transform(this, loader, className, classBeingRedefined, protectionDomain, classfileBuffer);
    }

    static {
        String string = System.getProperty("dumpBytecode");
        dumpBytecode = string != null ? Boolean.parseBoolean(string) : false;
        modifiers = new ArrayList();
    }
}

