/*
 * Decompiled with CFR 0.152.
 */
package net.weavemc.internals;

import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\u001a\u000e\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003\u00a8\u0006\u0004"}, d2={"getVanillaMinecraftJar", "Ljava/io/File;", "version", "", "Weave-Internals"})
public final class MappingsRetrievalKt {
    @NotNull
    public static final File getVanillaMinecraftJar(@NotNull String version2) {
        String[] stringArray;
        String[] stringArray2;
        Intrinsics.checkNotNullParameter(version2, "version");
        String string = System.getProperty("os.name");
        Intrinsics.checkNotNullExpressionValue(string, "getProperty(...)");
        String string2 = string.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue(string2, "toLowerCase(...)");
        String os = string2;
        String string3 = System.getProperty("user.home");
        if (StringsKt.contains$default((CharSequence)os, "win", false, 2, null)) {
            stringArray2 = new String[]{"AppData", "Roaming", ".minecraft"};
            stringArray = stringArray2;
        } else if (StringsKt.contains$default((CharSequence)os, "mac", false, 2, null)) {
            stringArray2 = new String[]{"Library", "Application Support", "minecraft"};
            stringArray = stringArray2;
        } else if (StringsKt.contains$default((CharSequence)os, "nix", false, 2, null) || StringsKt.contains$default((CharSequence)os, "nux", false, 2, null) || StringsKt.contains$default((CharSequence)os, "aix", false, 2, null)) {
            stringArray2 = new String[]{".minecraft"};
            stringArray = stringArray2;
        } else {
            throw new IllegalStateException("Failed to retrieve Vanilla Minecraft Jar due to an unsupported OS.".toString());
        }
        String[] stringArray3 = stringArray;
        Path minecraftPath = Paths.get(string3, Arrays.copyOf(stringArray3, stringArray3.length));
        File file = minecraftPath.resolve("versions").resolve(version2).resolve(version2 + ".jar").toFile();
        Intrinsics.checkNotNullExpressionValue(file, "toFile(...)");
        return file;
    }
}

