/*
 * Decompiled with CFR 0.152.
 */
package net.weavemc.internals;

import java.util.Map;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import net.weavemc.internals.GameInfo;
import net.weavemc.internals.MinecraftClient;
import net.weavemc.internals.MinecraftVersion;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010$\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u001b\u0010\u0003\u001a\u00020\u00048FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0007\u0010\b\u001a\u0004\b\u0005\u0010\u0006R\u001b\u0010\t\u001a\u00020\n8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\r\u0010\b\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u000e\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\fR\u001d\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\n0\u00118F\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u001b\u0010\u0014\u001a\u00020\u00158FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0018\u0010\b\u001a\u0004\b\u0016\u0010\u0017R\u001b\u0010\u0019\u001a\u00020\n8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001b\u0010\b\u001a\u0004\b\u001a\u0010\f\u00a8\u0006\u001c"}, d2={"Lnet/weavemc/internals/GameInfo;", "", "()V", "client", "Lnet/weavemc/internals/MinecraftClient;", "getClient", "()Lnet/weavemc/internals/MinecraftClient;", "client$delegate", "Lkotlin/Lazy;", "clientString", "", "getClientString", "()Ljava/lang/String;", "clientString$delegate", "commandLineArgs", "getCommandLineArgs", "rawGameInfo", "", "getRawGameInfo", "()Ljava/util/Map;", "version", "Lnet/weavemc/internals/MinecraftVersion;", "getVersion", "()Lnet/weavemc/internals/MinecraftVersion;", "version$delegate", "versionString", "getVersionString", "versionString$delegate", "Weave-Internals"})
public final class GameInfo {
    @NotNull
    public static final GameInfo INSTANCE = new GameInfo();
    @NotNull
    private static final String commandLineArgs;
    @NotNull
    private static final Lazy versionString$delegate;
    @NotNull
    private static final Lazy version$delegate;
    @NotNull
    private static final Lazy clientString$delegate;
    @NotNull
    private static final Lazy client$delegate;

    private GameInfo() {
    }

    @NotNull
    public final Map<String, String> getRawGameInfo() {
        Object object = System.getProperties().get("weave.game.info");
        Map map = object instanceof Map ? (Map)object : null;
        if (map == null) {
            throw new IllegalStateException("Failed to retrieve Minecraft arguments".toString());
        }
        return map;
    }

    @NotNull
    public final String getCommandLineArgs() {
        return commandLineArgs;
    }

    @NotNull
    public final String getVersionString() {
        Lazy lazy = versionString$delegate;
        return (String)lazy.getValue();
    }

    @NotNull
    public final MinecraftVersion getVersion() {
        Lazy lazy = version$delegate;
        return (MinecraftVersion)((Object)lazy.getValue());
    }

    @NotNull
    public final String getClientString() {
        Lazy lazy = clientString$delegate;
        return (String)lazy.getValue();
    }

    @NotNull
    public final MinecraftClient getClient() {
        Lazy lazy = client$delegate;
        return (MinecraftClient)((Object)lazy.getValue());
    }

    static {
        String string = System.getProperty("sun.java.command");
        if (string == null) {
            throw new IllegalStateException("Failed to retrieve command line arguments, this should never happen.".toString());
        }
        commandLineArgs = string;
        versionString$delegate = LazyKt.lazy(versionString.2.INSTANCE);
        version$delegate = LazyKt.lazy(version.2.INSTANCE);
        clientString$delegate = LazyKt.lazy(clientString.2.INSTANCE);
        client$delegate = LazyKt.lazy(client.2.INSTANCE);
    }
}

