/*
 * Decompiled with CFR 0.152.
 */
package com.grappenmaker.mappings;

import com.grappenmaker.mappings.Mappings;
import com.grappenmaker.mappings.MappingsFormat;
import com.grappenmaker.mappings.ProguardMappingsFormat;
import com.grappenmaker.mappings.SRGMappingsFormat;
import com.grappenmaker.mappings.TSRGV1MappingsFormat;
import com.grappenmaker.mappings.TSRGV2MappingsFormat;
import com.grappenmaker.mappings.TinyMappingsV1Format;
import com.grappenmaker.mappings.TinyMappingsV2Format;
import com.grappenmaker.mappings.XSRGMappingsFormat;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\b\u001a\u0006\u0012\u0002\b\u00030\u00052\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u0004J\u0014\u0010\u000b\u001a\u00020\f2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u0004R\u001b\u0010\u0003\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\r"}, d2={"Lcom/grappenmaker/mappings/MappingsLoader;", "", "()V", "allMappingsFormats", "", "Lcom/grappenmaker/mappings/MappingsFormat;", "getAllMappingsFormats", "()Ljava/util/List;", "findMappingsFormat", "lines", "", "loadMappings", "Lcom/grappenmaker/mappings/Mappings;", "mappings-util"})
@SourceDebugExtension(value={"SMAP\nMappings.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Mappings.kt\ncom/grappenmaker/mappings/MappingsLoader\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,147:1\n1#2:148\n*E\n"})
public final class MappingsLoader {
    @NotNull
    public static final MappingsLoader INSTANCE = new MappingsLoader();
    @NotNull
    private static final List<MappingsFormat<?>> allMappingsFormats;

    private MappingsLoader() {
    }

    @NotNull
    public final List<MappingsFormat<?>> getAllMappingsFormats() {
        return allMappingsFormats;
    }

    @NotNull
    public final MappingsFormat<?> findMappingsFormat(@NotNull List<String> lines) {
        Object v0;
        block2: {
            Intrinsics.checkNotNullParameter(lines, "lines");
            Iterable iterable = allMappingsFormats;
            for (Object t : iterable) {
                MappingsFormat it = (MappingsFormat)t;
                boolean bl = false;
                if (!it.detect(lines)) continue;
                v0 = t;
                break block2;
            }
            v0 = null;
        }
        MappingsFormat mappingsFormat = v0;
        if (mappingsFormat == null) {
            throw new IllegalStateException("No format was found for mappings".toString());
        }
        return mappingsFormat;
    }

    @NotNull
    public final Mappings loadMappings(@NotNull List<String> lines) {
        Intrinsics.checkNotNullParameter(lines, "lines");
        return this.findMappingsFormat(lines).parse(lines);
    }

    static {
        MappingsFormat[] mappingsFormatArray = new MappingsFormat[]{TinyMappingsV1Format.INSTANCE, TinyMappingsV2Format.INSTANCE, SRGMappingsFormat.INSTANCE, XSRGMappingsFormat.INSTANCE, ProguardMappingsFormat.INSTANCE, TSRGV1MappingsFormat.INSTANCE, TSRGV2MappingsFormat.INSTANCE};
        allMappingsFormats = CollectionsKt.listOf(mappingsFormatArray);
    }
}

