/*
 * Decompiled with CFR 0.152.
 */
package com.grappenmaker.mappings;

import com.grappenmaker.mappings.ClasspathLoaders;
import com.grappenmaker.mappings.ClasspathLoadersKt;
import com.grappenmaker.mappings.CompoundClasspathLoader;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.io.ByteStreamsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0082\u0001\u0010\u0003\u001a#\u0012\u0013\u0012\u00110\u0005\u00a2\u0006\f\b\u0006\u0012\b\b\u0007\u0012\u0004\b\b(\u0007\u0012\u0006\u0012\u0004\u0018\u00010\b0\u0004j\u0002`\t2T\u0010\n\u001a+\u0012'\b\u0001\u0012#\u0012\u0013\u0012\u00110\u0005\u00a2\u0006\f\b\u0006\u0012\b\b\u0007\u0012\u0004\b\b(\u0007\u0012\u0006\u0012\u0004\u0018\u00010\b0\u0004j\u0002`\t0\u000b\"#\u0012\u0013\u0012\u00110\u0005\u00a2\u0006\f\b\u0006\u0012\b\b\u0007\u0012\u0004\b\b(\u0007\u0012\u0006\u0012\u0004\u0018\u00010\b0\u0004j\u0002`\t\u00a2\u0006\u0002\u0010\fJV\u0010\u0003\u001a#\u0012\u0013\u0012\u00110\u0005\u00a2\u0006\f\b\u0006\u0012\b\b\u0007\u0012\u0004\b\b(\u0007\u0012\u0006\u0012\u0004\u0018\u00010\b0\u0004j\u0002`\t2-\u0010\n\u001a)\u0012%\u0012#\u0012\u0013\u0012\u00110\u0005\u00a2\u0006\f\b\u0006\u0012\b\b\u0007\u0012\u0004\b\b(\u0007\u0012\u0006\u0012\u0004\u0018\u00010\b0\u0004j\u0002`\t0\rJ5\u0010\u000e\u001a#\u0012\u0013\u0012\u00110\u0005\u00a2\u0006\f\b\u0006\u0012\b\b\u0007\u0012\u0004\b\b(\u0007\u0012\u0006\u0012\u0004\u0018\u00010\b0\u0004j\u0002`\t2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00100\rJ/\u0010\u0011\u001a#\u0012\u0013\u0012\u00110\u0005\u00a2\u0006\f\b\u0006\u0012\b\b\u0007\u0012\u0004\b\b(\u0007\u0012\u0006\u0012\u0004\u0018\u00010\b0\u0004j\u0002`\t2\u0006\u0010\u0012\u001a\u00020\u0013J'\u0010\u0014\u001a#\u0012\u0013\u0012\u00110\u0005\u00a2\u0006\f\b\u0006\u0012\b\b\u0007\u0012\u0004\b\b(\u0007\u0012\u0006\u0012\u0004\u0018\u00010\b0\u0004j\u0002`\t\u00a8\u0006\u0015"}, d2={"Lcom/grappenmaker/mappings/ClasspathLoaders;", "", "()V", "compound", "Lkotlin/Function1;", "", "Lkotlin/ParameterName;", "name", "", "Lcom/grappenmaker/mappings/ClasspathLoader;", "loaders", "", "([Lkotlin/jvm/functions/Function1;)Lkotlin/jvm/functions/Function1;", "", "fromJars", "jars", "Ljava/util/jar/JarFile;", "fromLoader", "loader", "Ljava/lang/ClassLoader;", "fromSystemLoader", "mappings-util"})
@SourceDebugExtension(value={"SMAP\nClasspathLoaders.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ClasspathLoaders.kt\ncom/grappenmaker/mappings/ClasspathLoaders\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,104:1\n1373#2:105\n1461#2,5:106\n*S KotlinDebug\n*F\n+ 1 ClasspathLoaders.kt\ncom/grappenmaker/mappings/ClasspathLoaders\n*L\n41#1:105\n41#1:106,5\n*E\n"})
public final class ClasspathLoaders {
    @NotNull
    public static final ClasspathLoaders INSTANCE = new ClasspathLoaders();

    private ClasspathLoaders() {
    }

    @NotNull
    public final Function1<String, byte[]> fromLoader(@NotNull ClassLoader loader) {
        Intrinsics.checkNotNullParameter(loader, "loader");
        return new Function1<String, byte[]>(loader){
            final /* synthetic */ ClassLoader $loader;
            {
                this.$loader = $loader;
                super(1);
            }

            @Nullable
            public final byte[] invoke(@NotNull String it) {
                Intrinsics.checkNotNullParameter(it, "it");
                InputStream inputStream = this.$loader.getResourceAsStream(it + ".class");
                return (byte[])(inputStream != null ? ByteStreamsKt.readBytes(inputStream) : null);
            }
        };
    }

    @NotNull
    public final Function1<String, byte[]> fromSystemLoader() {
        ClassLoader classLoader = ClassLoader.getSystemClassLoader();
        Intrinsics.checkNotNullExpressionValue(classLoader, "getSystemClassLoader(...)");
        return this.fromLoader(classLoader);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Function1<String, byte[]> fromJars(@NotNull List<? extends JarFile> jars) {
        void $this$flatMapTo$iv$iv;
        Intrinsics.checkNotNullParameter(jars, "jars");
        Iterable $this$flatMap$iv = jars;
        boolean $i$f$flatMapSequence = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapSequenceTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            JarFile f = (JarFile)element$iv$iv;
            boolean bl = false;
            Enumeration<JarEntry> enumeration = f.entries();
            Intrinsics.checkNotNullExpressionValue(enumeration, "entries(...)");
            Sequence list$iv$iv = SequencesKt.map(SequencesKt.filter(SequencesKt.asSequence(CollectionsKt.iterator(enumeration)), fromJars.index.1.1.INSTANCE), (Function1)new Function1<JarEntry, Pair<? extends String, ? extends Pair<? extends JarFile, ? extends JarEntry>>>(f){
                final /* synthetic */ JarFile $f;
                {
                    this.$f = $f;
                    super(1);
                }

                @NotNull
                public final Pair<String, Pair<JarFile, JarEntry>> invoke(JarEntry it) {
                    String string = it.getName();
                    Intrinsics.checkNotNullExpressionValue(string, "getName(...)");
                    return TuplesKt.to(StringsKt.dropLast(string, 6), TuplesKt.to(this.$f, it));
                }
            });
            CollectionsKt.addAll(destination$iv$iv, list$iv$iv);
        }
        Map index2 = MapsKt.toMap((List)destination$iv$iv);
        return new Function1<String, byte[]>(index2){
            final /* synthetic */ Map<String, Pair<JarFile, JarEntry>> $index;
            {
                this.$index = $index;
                super(1);
            }

            @Nullable
            public final byte[] invoke(@NotNull String it) {
                byte[] byArray;
                Intrinsics.checkNotNullParameter(it, "it");
                Pair<JarFile, JarEntry> pair = this.$index.get(it);
                if (pair != null) {
                    Pair<JarFile, JarEntry> pair2 = pair;
                    boolean bl = false;
                    JarFile f = pair2.component1();
                    JarEntry e = pair2.component2();
                    InputStream inputStream = f.getInputStream(e);
                    Intrinsics.checkNotNullExpressionValue(inputStream, "getInputStream(...)");
                    byArray = ByteStreamsKt.readBytes(inputStream);
                } else {
                    byArray = null;
                }
                return byArray;
            }
        };
    }

    @NotNull
    public final Function1<String, byte[]> compound(@NotNull List<? extends Function1<? super String, byte[]>> loaders) {
        Intrinsics.checkNotNullParameter(loaders, "loaders");
        return new CompoundClasspathLoader(ClasspathLoadersKt.access$flatten(loaders));
    }

    @NotNull
    public final Function1<String, byte[]> compound(Function1<? super String, byte[]> ... loaders) {
        Intrinsics.checkNotNullParameter(loaders, "loaders");
        return new CompoundClasspathLoader(ClasspathLoadersKt.access$flatten(ArraysKt.toList(loaders)));
    }
}

