/*
 * Decompiled with CFR 0.152.
 */
package net.weavemc.loader.mappings;

import java.io.DataInputStream;
import java.io.InputStream;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.objectweb.asm.commons.Remapper;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\b\u000f\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\n\u001a\u00020\u00032\u0006\u0010\u000b\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\u0003H\u0002J\u0010\u0010\r\u001a\u00020\u00032\u0006\u0010\u000e\u001a\u00020\u0003H\u0016J \u0010\u000f\u001a\u00020\u00032\u0006\u0010\u0010\u001a\u00020\u00032\u0006\u0010\u0011\u001a\u00020\u00032\u0006\u0010\u0012\u001a\u00020\u0003H\u0016J \u0010\u0013\u001a\u00020\u00032\u0006\u0010\u0010\u001a\u00020\u00032\u0006\u0010\u0011\u001a\u00020\u00032\u0006\u0010\u0012\u001a\u00020\u0003H\u0016J\u000e\u0010\u0014\u001a\u00020\u00032\u0006\u0010\u000e\u001a\u00020\u0003J\u001c\u0010\u0015\u001a\u00020\u0016*\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00032\u0006\u0010\u0019\u001a\u00020\u0003H\u0002J\f\u0010\u001a\u001a\u00020\u0016*\u00020\u0017H\u0002R\u001a\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lnet/weavemc/loader/mappings/KinRemapper;", "Lorg/objectweb/asm/commons/Remapper;", "resource", "", "(Ljava/lang/String;)V", "classes", "", "classesReverse", "fields", "methods", "constructName", "prefix", "suffix", "map", "internalName", "mapFieldName", "owner", "name", "descriptor", "mapMethodName", "mapReverse", "readClassMapping", "", "Ljava/io/DataInputStream;", "obfedName", "deobfedName", "readKin", "Weave-Loader"})
@SourceDebugExtension(value={"SMAP\nKinRemapper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KinRemapper.kt\nnet/weavemc/loader/mappings/KinRemapper\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,62:1\n1#2:63\n*E\n"})
public final class KinRemapper
extends Remapper {
    @NotNull
    private final Map<String, String> classes;
    @NotNull
    private final Map<String, String> classesReverse;
    @NotNull
    private final Map<String, String> methods;
    @NotNull
    private final Map<String, String> fields;

    /*
     * WARNING - void declaration
     */
    public KinRemapper(@NotNull String resource) {
        Intrinsics.checkNotNullParameter(resource, "resource");
        this.classes = new LinkedHashMap();
        this.classesReverse = new LinkedHashMap();
        this.methods = new LinkedHashMap();
        this.fields = new LinkedHashMap();
        try {
            void p0;
            InputStream inputStream = this.getClass().getResourceAsStream(resource);
            if (inputStream == null) {
                throw new IllegalStateException(("Could not find " + resource).toString());
            }
            InputStream inputStream2 = inputStream;
            KinRemapper kinRemapper = this;
            boolean bl = false;
            kinRemapper.readKin(new DataInputStream((InputStream)p0));
        }
        catch (Exception e) {
            System.out.println((Object)"[Weave] An error occurred while trying to read mappings, defaulting to NONE!");
            e.printStackTrace();
        }
    }

    private final void readKin(DataInputStream $this$readKin) {
        int it;
        if (!($this$readKin.readInt() == 99151942)) {
            boolean $i$a$-check-KinRemapper$readKin$32 = false;
            String $i$a$-check-KinRemapper$readKin$32 = "Invalid magic";
            throw new IllegalStateException($i$a$-check-KinRemapper$readKin$32.toString());
        }
        if (!($this$readKin.readByte() == 1)) {
            boolean bl = false;
            String string = "Invalid version";
            throw new IllegalStateException(string.toString());
        }
        int n = $this$readKin.readInt() << 1;
        int n2 = 0;
        while (n2 < n) {
            it = n2++;
            boolean bl = false;
            $this$readKin.readUTF();
        }
        n = $this$readKin.readInt();
        n2 = 0;
        while (n2 < n) {
            it = n2++;
            boolean bl = false;
            String string = $this$readKin.readUTF();
            Intrinsics.checkNotNullExpressionValue(string, "readUTF()");
            String string2 = $this$readKin.readUTF();
            Intrinsics.checkNotNullExpressionValue(string2, "readUTF()");
            this.readClassMapping($this$readKin, string, string2);
        }
    }

    private final String constructName(String prefix, String suffix) {
        return ((CharSequence)prefix).length() == 0 ? suffix : prefix + '$' + suffix;
    }

    private final void readClassMapping(DataInputStream $this$readClassMapping, String obfedName, String deobfedName) {
        String string;
        Object object;
        int it;
        this.classes.put(obfedName, deobfedName);
        this.classesReverse.put(deobfedName, obfedName);
        int n = $this$readClassMapping.readInt();
        int n2 = 0;
        while (n2 < n) {
            it = n2++;
            boolean bl = false;
            String string2 = $this$readClassMapping.readUTF();
            Intrinsics.checkNotNullExpressionValue(string2, "readUTF()");
            String string3 = this.constructName(obfedName, string2);
            String string4 = $this$readClassMapping.readUTF();
            Intrinsics.checkNotNullExpressionValue(string4, "readUTF()");
            this.readClassMapping($this$readClassMapping, string3, this.constructName(deobfedName, string4));
        }
        n = $this$readClassMapping.readInt();
        n2 = 0;
        while (n2 < n) {
            String string5;
            it = n2++;
            boolean bl = false;
            String obfedFieldName = $this$readClassMapping.readUTF();
            $this$readClassMapping.readUTF();
            object = this.fields;
            string = obfedName + '.' + obfedFieldName;
            Intrinsics.checkNotNullExpressionValue($this$readClassMapping.readUTF(), "readUTF()");
            object.put(string, string5);
        }
        n = $this$readClassMapping.readInt();
        n2 = 0;
        while (n2 < n) {
            it = n2++;
            boolean bl = false;
            Map<String, String> map = this.methods;
            object = obfedName + '.' + $this$readClassMapping.readUTF() + $this$readClassMapping.readUTF();
            Intrinsics.checkNotNullExpressionValue($this$readClassMapping.readUTF(), "readUTF()");
            map.put((String)object, string);
        }
    }

    @NotNull
    public final String mapReverse(@NotNull String internalName) {
        Intrinsics.checkNotNullParameter(internalName, "internalName");
        String string = this.classesReverse.get(internalName);
        if (string == null) {
            string = internalName;
        }
        return string;
    }

    @Override
    @NotNull
    public String map(@NotNull String internalName) {
        Intrinsics.checkNotNullParameter(internalName, "internalName");
        return this.classes.getOrDefault(internalName, internalName);
    }

    @Override
    @NotNull
    public String mapMethodName(@NotNull String owner, @NotNull String name, @NotNull String descriptor2) {
        Intrinsics.checkNotNullParameter(owner, "owner");
        Intrinsics.checkNotNullParameter(name, "name");
        Intrinsics.checkNotNullParameter(descriptor2, "descriptor");
        return this.methods.getOrDefault(owner + '.' + name + descriptor2, name);
    }

    @Override
    @NotNull
    public String mapFieldName(@NotNull String owner, @NotNull String name, @NotNull String descriptor2) {
        Intrinsics.checkNotNullParameter(owner, "owner");
        Intrinsics.checkNotNullParameter(name, "name");
        Intrinsics.checkNotNullParameter(descriptor2, "descriptor");
        return this.fields.getOrDefault(owner + '.' + name, name);
    }
}

