/*
 * Decompiled with CFR 0.152.
 */
package net.weavemc.loader.api.command;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import net.weavemc.loader.api.command.Command;
import net.weavemc.loader.api.event.ChatSentEvent;
import net.weavemc.loader.api.event.EventBus;

public final class CommandBus {
    private static final List<Command> commands = new ArrayList<Command>();

    public static void register(Command command) {
        commands.add(command);
    }

    private CommandBus() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    static {
        EventBus.subscribe(ChatSentEvent.class, e -> {
            if (!e.getMessage().startsWith("/")) {
                return;
            }
            String[] split = e.getMessage().substring(1).split("\\s+");
            Iterator matching = commands.stream().filter(c -> c.matches(split[0])).iterator();
            if (!matching.hasNext()) {
                return;
            }
            e.setCancelled(true);
            String[] args2 = Arrays.copyOfRange(split, 1, split.length);
            matching.forEachRemaining(c -> c.handle(args2));
        });
    }
}

