/*
 * Decompiled with CFR 0.152.
 */
package net.weavemc.loader.api.event;

import java.lang.reflect.Method;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Consumer;
import net.weavemc.loader.api.event.Event;
import net.weavemc.loader.api.event.SubscribeEvent;
import org.jetbrains.annotations.NotNull;

public final class EventBus {
    private static final Map<Class<?>, List<Consumer<?>>> map = new ConcurrentHashMap();

    public static void subscribe(Object obj) {
        for (Method method : obj.getClass().getDeclaredMethods()) {
            if (!method.isAnnotationPresent(SubscribeEvent.class) || method.getParameterCount() != 1) continue;
            EventBus.getListeners(method.getParameterTypes()[0]).add(new ReflectEventConsumer(obj, method));
        }
    }

    public static <T extends Event> void subscribe(Class<T> event, Consumer<T> handler) {
        EventBus.getListeners(event).add(handler);
    }

    public static <T extends Event> void callEvent(T event) {
        for (Class<?> c = event.getClass(); c != Object.class; c = c.getSuperclass()) {
            EventBus.getListeners(c).forEach(l -> l.accept(event));
        }
    }

    public static void unsubscribe(Consumer<? extends Event> consumer2) {
        for (List<Consumer<?>> list : map.values()) {
            list.removeIf(c -> c == consumer2);
        }
    }

    public static void unsubscribe(Object obj) {
        for (List<Consumer<?>> list : map.values()) {
            list.removeIf(c -> c instanceof ReflectEventConsumer && ((ReflectEventConsumer)c).obj == obj);
        }
    }

    @NotNull
    private static List<Consumer<?>> getListeners(Class<?> event) {
        return map.computeIfAbsent(event, e -> new CopyOnWriteArrayList());
    }

    private EventBus() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    private static class ReflectEventConsumer
    implements Consumer<Event> {
        private final Object obj;
        private final Method method;

        @Override
        public void accept(Event event) {
            this.method.invoke(this.obj, event);
        }

        public ReflectEventConsumer(Object obj, Method method) {
            this.obj = obj;
            this.method = method;
        }
    }
}

