/*
 * Decompiled with CFR 0.152.
 */
package org.earthsworth.browseroffline;

import java.io.ByteArrayInputStream;
import java.lang.instrument.ClassFileTransformer;
import java.lang.instrument.Instrumentation;
import java.security.ProtectionDomain;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtMethod;
import javassist.LoaderClassPath;
import javassist.bytecode.ConstPool;

public class BrowserOfflineAgent {
    private static final String CLASS_ANCHOR = "https://login.live.com/oauth20_desktop.srf";

    public static void premain(String agentArgs, Instrumentation inst) {
        System.out.println("[BrowserOffline] Agent loaded.");
        inst.addTransformer(new AuthTransformer(), true);
    }

    static class AuthTransformer
    implements ClassFileTransformer {
        AuthTransformer() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public byte[] transform(ClassLoader loader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) {
            if (className == null || !className.startsWith("com/moonsworth/lunar/client")) {
                return null;
            }
            CtClass cc = null;
            try {
                ClassPool cp = ClassPool.getDefault();
                if (loader != null) {
                    cp.insertClassPath(new LoaderClassPath(loader));
                }
                if (!this.hasConstantString(cc = cp.makeClass(new ByteArrayInputStream(classfileBuffer)), BrowserOfflineAgent.CLASS_ANCHOR)) {
                    byte[] byArray = null;
                    return byArray;
                }
                System.out.println("[BrowserOffline] Target Class Found: " + className);
                boolean modified = false;
                for (CtMethod m : cc.getDeclaredMethods()) {
                    CtClass[] params = m.getParameterTypes();
                    if (params.length <= 0 || !params[params.length - 1].getName().equals("java.util.function.Consumer")) continue;
                    int consumerIndex = -1;
                    if (params.length == 3) {
                        consumerIndex = 3;
                    } else if (params.length == 4) {
                        consumerIndex = 4;
                    }
                    if (consumerIndex == -1) continue;
                    System.out.println("[BrowserOffline] Patching Method: " + m.getName() + " (Args: " + params.length + ")");
                    String returnStatement = "return;";
                    CtClass returnType = m.getReturnType();
                    if (returnType != CtClass.voidType) {
                        returnStatement = returnType.isPrimitive() ? "return 0;" : "return null;";
                        System.out.println("[BrowserOffline] Detected non-void return type, adjusting return statement.");
                    }
                    String bypassCode = "{  try {    Object acc = $1;    boolean explicitOffline = false;    int longStringCount = 0;    if (acc != null) {      Class clazz = acc.getClass();      while (clazz != null && clazz != Object.class) {        java.lang.reflect.Field[] fields = clazz.getDeclaredFields();        for (int i = 0; i < fields.length; i++) {          try {            java.lang.reflect.Field f = fields[i];            f.setAccessible(true);            if (f.getType() == java.lang.String.class) {              String val = (String) f.get(acc);              if (val != null) {                if (val.equals(\"OFFLINE_ALT\")) explicitOffline = true;                if (val.length() > 64) longStringCount++;              }            }          } catch (Throwable t) {}        }        clazz = clazz.getSuperclass();      }    }    if (explicitOffline || longStringCount < 2) {      System.out.println(\"[BrowserOffline] OFFLINE DETECTED. Bypassing...\");      Class c2 = acc.getClass();      while (c2 != null && c2 != Object.class) {        java.lang.reflect.Field[] fs2 = c2.getDeclaredFields();        for (int j = 0; j < fs2.length; j++) {          try {            java.lang.reflect.Field f2 = fs2[j];            f2.setAccessible(true);            if (f2.getType() == java.lang.String.class) {               String current = (String) f2.get(acc);               if (current == null || current.length() > 64) {                 f2.set(acc, \"OFFLINE_ALT\");               }            }          } catch (Throwable t) {}        }        c2 = c2.getSuperclass();      }      $" + consumerIndex + ".accept(java.lang.Boolean.TRUE);      " + returnStatement + "    } else {      System.out.println(\"[BrowserOffline] LEGIT DETECTED. Passing through.\");    }  } catch (Exception e) {    e.printStackTrace();  }}";
                    m.insertBefore(bypassCode);
                    modified = true;
                }
                if (modified) {
                    byte[] byteCode = cc.toBytecode();
                    System.out.println("[BrowserOffline] Patch Applied Successfully.");
                    byte[] byArray = byteCode;
                    return byArray;
                }
            }
            catch (Exception e) {
                System.err.println("[BrowserOffline] Error transforming class:");
                e.printStackTrace();
            }
            finally {
                if (cc != null) {
                    cc.detach();
                }
            }
            return null;
        }

        private boolean hasConstantString(CtClass cc, String target) {
            ConstPool cp = cc.getClassFile().getConstPool();
            int size = cp.getSize();
            for (int i = 1; i < size; ++i) {
                String str;
                if (cp.getTag(i) != 8 || (str = cp.getStringInfo(i)) == null || !str.equals(target)) continue;
                return true;
            }
            return false;
        }
    }
}

