/*
 * Decompiled with CFR 0.152.
 */
package org.cubewhy.celestial.debugger.agent;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.FieldVisitor;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J6\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0012\u001a\u00020\u00052\u0006\u0010\u0013\u001a\u00020\n2\u0006\u0010\u0014\u001a\u00020\n2\b\u0010\u0015\u001a\u0004\u0018\u00010\n2\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u0016J.\u0010\u0018\u001a\u00020\u00192\b\u0010\u0013\u001a\u0004\u0018\u00010\n2\b\u0010\u001a\u001a\u0004\u0018\u00010\n2\b\u0010\u001b\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0012\u001a\u00020\u0005H\u0016J\u0006\u0010\u001c\u001a\u00020\u0007R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010\t\u001a\u0004\u0018\u00010\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u000e\u0010\u000f\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lorg/cubewhy/celestial/debugger/agent/ClassAnalyzer;", "Lorg/objectweb/asm/ClassVisitor;", "<init>", "()V", "staticFieldCount", "", "hasBooleanField", "", "stringFieldCount", "booleanFieldName", "", "getBooleanFieldName", "()Ljava/lang/String;", "setBooleanFieldName", "(Ljava/lang/String;)V", "hasTargetEnum", "visitField", "Lorg/objectweb/asm/FieldVisitor;", "access", "name", "descriptor", "signature", "value", "", "visitInnerClass", "", "outerName", "innerName", "matchesCriteria", "BrowserDebugger"})
public final class ClassAnalyzer
extends ClassVisitor {
    private int staticFieldCount;
    private boolean hasBooleanField;
    private int stringFieldCount;
    @Nullable
    private String booleanFieldName;
    private boolean hasTargetEnum;

    public ClassAnalyzer() {
        super(589824);
    }

    @Nullable
    public final String getBooleanFieldName() {
        return this.booleanFieldName;
    }

    public final void setBooleanFieldName(@Nullable String string) {
        this.booleanFieldName = string;
    }

    @Nullable
    public FieldVisitor visitField(int access, @NotNull String name, @NotNull String descriptor, @Nullable String signature, @Nullable Object value) {
        Intrinsics.checkNotNullParameter(name, "name");
        Intrinsics.checkNotNullParameter(descriptor, "descriptor");
        if ((access & 8) != 0) {
            int n = this.staticFieldCount;
            this.staticFieldCount = n + 1;
            String string = descriptor;
            if (Intrinsics.areEqual(string, "Z")) {
                this.hasBooleanField = true;
                this.booleanFieldName = name;
            } else if (Intrinsics.areEqual(string, "Ljava/lang/String;")) {
                int n2 = this.stringFieldCount;
                this.stringFieldCount = n2 + 1;
            }
        }
        return super.visitField(access, name, descriptor, signature, value);
    }

    public void visitInnerClass(@Nullable String name, @Nullable String outerName, @Nullable String innerName, int access) {
        if ((access & 0x4000) != 0) {
            this.hasTargetEnum = true;
        }
    }

    public final boolean matchesCriteria() {
        return (this.staticFieldCount == 8 && this.stringFieldCount == 7 || this.staticFieldCount == 6 && this.stringFieldCount == 5) && this.hasBooleanField && this.hasTargetEnum;
    }
}

