/*
 * Decompiled with CFR 0.152.
 */
package org.cubewhy.celestial.debugger.agent;

import java.lang.instrument.Instrumentation;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.cubewhy.celestial.debugger.agent.BrowserDebuggerAgentKt;
import org.cubewhy.celestial.debugger.agent.ClassTransformer;
import org.cubewhy.celestial.debugger.entity.ApiServer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0004\u0018\u0000 \u00042\u00020\u0001:\u0001\u0004B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0005"}, d2={"Lorg/cubewhy/celestial/debugger/agent/BrowserDebuggerAgent;", "", "<init>", "()V", "Companion", "BrowserDebugger"})
public final class BrowserDebuggerAgent {
    @NotNull
    public static final Companion Companion = new Companion(null);

    @JvmStatic
    public static final void premain(@Nullable String agentArgs, @NotNull Instrumentation inst) {
        Companion.premain(agentArgs, inst);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001a\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\tH\u0007\u00a8\u0006\n"}, d2={"Lorg/cubewhy/celestial/debugger/agent/BrowserDebuggerAgent$Companion;", "", "<init>", "()V", "premain", "", "agentArgs", "", "inst", "Ljava/lang/instrument/Instrumentation;", "BrowserDebugger"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        public final void premain(@Nullable String agentArgs, @NotNull Instrumentation inst) {
            Intrinsics.checkNotNullParameter(inst, "inst");
            System.out.println((Object)"[BrowserDebugger] Welcome to LunarCN! https://lunarclient.top");
            System.out.println((Object)"[BrowserDebugger] Enjoy the FOSS power!");
            System.out.println((Object)"[BrowserDebugger] This software is complete open source, you can view the backend source at https://codeberg.org/earthsworth/lunar-api");
            System.out.println((Object)"[BrowserDebugger] And the frontend stuff at https://github.com/earthsworth/BrowserDebugger");
            if (!Intrinsics.areEqual(agentArgs, "proprietary")) {
                String apiAddress = System.getProperty("celestialApiAddress", "ws.lunarclient.top");
                boolean useEncryption = Boolean.parseBoolean(System.getProperty("celestialApiUseEncryption", "true"));
                Intrinsics.checkNotNull(apiAddress);
                ApiServer dto = new ApiServer(useEncryption, apiAddress);
                boolean bl = false;
                System.out.println((Object)("[BrowserDebugger] Lunar-API Server info: " + dto.getAddress() + " (" + (dto.getEncrypted() ? "encrypted" : "unencrypted") + ")"));
                BrowserDebuggerAgentKt.access$updateOverride("Authenticator", dto.getWsBase() + "/ws");
                BrowserDebuggerAgentKt.access$updateOverride("AssetServer", dto.getWsBase() + "/ws");
                BrowserDebuggerAgentKt.access$updateOverride("Api", dto.getHttpBase() + "/api/lunar");
                BrowserDebuggerAgentKt.access$updateOverride("Styngr", dto.getHttpBase() + "/api/styngr");
            } else {
                System.out.println((Object)"[BrowserDebugger] Using the proprietary backend");
            }
            System.out.println((Object)"[BrowserDebugger] Patching...");
            inst.addTransformer(new ClassTransformer(), true);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

